/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import io.github.liquibaselinter.ChangeLogLintingException;
import io.github.liquibaselinter.RuleRunner;
import io.github.liquibaselinter.config.Config;
import io.github.liquibaselinter.config.ConfigLoader;
import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.report.ReportItem;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.ContextExpression;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;

public class ChangeLogLinter {
    private final Config config;
    private final RuleRunner ruleRunner;
    private final ResourceAccessor resourceAccessor;

    public ChangeLogLinter(ResourceAccessor resourceAccessor, Config config) {
        Objects.requireNonNull(resourceAccessor, "ResourceAccessor must not be null");
        Objects.requireNonNull(config, "Configuration must not be null");
        this.resourceAccessor = resourceAccessor;
        this.config = config;
        this.ruleRunner = new RuleRunner(this.config);
    }

    public ChangeLogLinter(ResourceAccessor resourceAccessor) {
        this(resourceAccessor, ConfigLoader.load(resourceAccessor));
    }

    public void lintChangeLog(DatabaseChangeLog databaseChangeLog) throws ChangeLogLintingException {
        if (this.shouldLint(databaseChangeLog)) {
            this.ruleRunner.checkChangeLog(databaseChangeLog);
        }
        this.lintChangeSets(databaseChangeLog.getChangeSets());
        this.ruleRunner.getFilesParsed().add(databaseChangeLog.getPhysicalFilePath());
        this.checkForFilesNotIncluded();
        this.reports();
    }

    private void lintChangeSets(List<ChangeSet> changeSets) throws ChangeLogLintingException {
        for (ChangeSet changeSet : changeSets) {
            DatabaseChangeLog databaseChangeLog = changeSet.getChangeLog();
            if (this.shouldLint(databaseChangeLog) && ChangeLogLinter.isNotRootChangeLog(databaseChangeLog)) {
                this.ruleRunner.checkChangeLog(databaseChangeLog);
            }
            if (this.shouldLint(changeSet)) {
                this.ruleRunner.checkChangeSet(changeSet);
                for (Change change : changeSet.getChanges()) {
                    this.ruleRunner.checkChange(change);
                }
            }
            this.ruleRunner.getFilesParsed().add(databaseChangeLog.getPhysicalFilePath());
        }
    }

    private static boolean isNotRootChangeLog(DatabaseChangeLog databaseChangeLog) {
        return databaseChangeLog.getRootChangeLog() != databaseChangeLog;
    }

    private boolean shouldLint(DatabaseChangeLog changeLog) {
        return this.isEnabled() && this.isFilePathNotIgnored(changeLog.getFilePath()) && !this.hasAlreadyBeenParsed(changeLog.getFilePath());
    }

    private boolean isEnabled() {
        return StringUtils.isEmpty((CharSequence)this.config.getEnableAfter()) || this.hasAlreadyBeenParsed(this.config.getEnableAfter());
    }

    private boolean hasAlreadyBeenParsed(String filePath) {
        return this.ruleRunner.getFilesParsed().contains(filePath);
    }

    private boolean shouldLint(ChangeSet changeSet) {
        return this.isEnabled() && !this.isContextIgnored(changeSet) && this.isFilePathNotIgnored(changeSet.getFilePath());
    }

    private boolean isContextIgnored(ChangeSet changeSet) {
        Set contexts = Optional.ofNullable(changeSet.getContextFilter()).map(ContextExpression::getContexts).orElseGet(Collections::emptySet);
        if (this.config.getIgnoreContextPattern() != null && !contexts.isEmpty()) {
            return contexts.stream().anyMatch(context -> this.config.getIgnoreContextPattern().matcher((CharSequence)context).matches());
        }
        return false;
    }

    private boolean isFilePathNotIgnored(String filePath) {
        if (filePath != null && this.config.getIgnoreFilesPattern() != null) {
            String changeLogPath = filePath.replace('\\', '/');
            return !this.config.getIgnoreFilesPattern().matcher(changeLogPath).matches();
        }
        return true;
    }

    private void checkForFilesNotIncluded() throws ChangeLogLintingException {
        Set fileExtensions = this.ruleRunner.getFilesParsed().stream().map(Files::getFileExtension).filter(ext -> !Strings.isNullOrEmpty((String)ext)).collect(Collectors.toSet());
        for (RuleConfig ruleConfig : this.config.getEnabledRuleConfig("file-not-included")) {
            List<String> paths = Optional.ofNullable(ruleConfig.getValues()).orElseThrow(() -> new IllegalArgumentException("values not configured for rule `file-not-included`"));
            for (String path : paths) {
                try {
                    String unparsedFiles = this.resourceAccessor.search(path, true).stream().map(Resource::getPath).filter(file -> fileExtensions.contains(Files.getFileExtension((String)file))).filter(file -> !this.ruleRunner.getFilesParsed().contains(file)).collect(Collectors.joining(","));
                    if (Strings.isNullOrEmpty((String)unparsedFiles)) continue;
                    String errorMessage = Optional.ofNullable(ruleConfig.getErrorMessage()).orElse("Changelog files not included in deltas change log: %s");
                    throw new ChangeLogLintingException(String.format(errorMessage, unparsedFiles));
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getLog(ChangeLogLinter.class).warning("Cannot list files in " + path, (Throwable)e);
                }
            }
        }
    }

    private void reports() throws ChangeLogLintingException {
        this.config.getReporting().forEach((reportType, reporter) -> {
            if (reporter.isEnabled()) {
                reporter.processReport(this.ruleRunner.buildReport());
            }
        });
        List errors = this.ruleRunner.buildReport().getItems().stream().filter(item -> item.getType() == ReportItem.ReportItemType.ERROR).collect(Collectors.toList());
        long errorCount = errors.size();
        if (errorCount > 0L) {
            String errorList = errors.stream().map(ReportItem::getMessage).collect(Collectors.joining("\n - ", "\n - ", ""));
            throw new ChangeLogLintingException(String.format("Linting failed with %d errors: %s", errorCount, errorList));
        }
    }
}

