/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@JsonDeserialize(builder=RuleConfigBuilder.class)
public final class RuleConfig {
    public static final RuleConfig EMPTY = RuleConfig.builder().build();
    private static final String DYNAMIC_VALUE = "{{value}}";
    private final boolean enabled;
    private final String condition;
    private final String patternString;
    private final String columnCondition;
    private final String dynamicValue;
    private final List<String> values;
    private final Integer maxLength;
    private final String errorMessage;
    private final String enableAfter;
    private Pattern pattern;
    private Expression conditionExpression;
    private Expression columnConditionExpression;
    private Expression dynamicValueExpression;

    private RuleConfig(RuleConfigBuilder builder) {
        this.enabled = builder.enabled;
        this.errorMessage = builder.errorMessage;
        this.condition = builder.condition;
        this.columnCondition = builder.columnCondition;
        this.patternString = builder.pattern;
        this.dynamicValue = builder.dynamicValue;
        this.values = builder.values;
        this.maxLength = builder.maxLength;
        this.enableAfter = builder.enableAfter;
    }

    public static RuleConfig enabled() {
        return RuleConfig.builder().withEnabled(true).build();
    }

    public static RuleConfig disabled() {
        return RuleConfig.builder().withEnabled(false).build();
    }

    public static RuleConfigBuilder builder() {
        return new RuleConfigBuilder();
    }

    public boolean hasDynamicPattern() {
        return this.patternString != null && this.patternString.contains(DYNAMIC_VALUE);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<String> getValues() {
        return this.values;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Optional<Expression> getConditionalColumnExpression() {
        if (this.columnCondition == null) {
            return Optional.empty();
        }
        if (this.columnConditionExpression == null) {
            this.columnConditionExpression = new SpelExpressionParser().parseExpression(this.columnCondition);
        }
        return Optional.of(this.columnConditionExpression);
    }

    public Optional<Expression> getConditionalExpression() {
        if (this.condition == null) {
            return Optional.empty();
        }
        if (this.conditionExpression == null) {
            this.conditionExpression = new SpelExpressionParser().parseExpression(this.condition);
        }
        return Optional.of(this.conditionExpression);
    }

    public Optional<Expression> getDynamicValueExpression() {
        if (this.dynamicValue == null) {
            return Optional.empty();
        }
        if (this.dynamicValueExpression == null) {
            this.dynamicValueExpression = new SpelExpressionParser().parseExpression(this.dynamicValue);
        }
        return Optional.of(this.dynamicValueExpression);
    }

    public Pattern getDynamicPattern(String value) {
        if (!this.hasDynamicPattern()) {
            throw new IllegalStateException("Pattern is not dynamic");
        }
        return Pattern.compile(this.getPatternString().replace(DYNAMIC_VALUE, value));
    }

    public String getDynamicValue(Object subject) {
        return this.getDynamicValueExpression().map(expression -> (String)expression.getValue(subject, String.class)).orElse(null);
    }

    public Optional<Pattern> getPattern() {
        if (this.pattern == null && this.patternString != null && !this.hasDynamicPattern()) {
            this.pattern = Pattern.compile(this.patternString);
        }
        return Optional.ofNullable(this.pattern);
    }

    public boolean hasPattern() {
        return this.patternString != null && !this.patternString.isEmpty();
    }

    public String getEnableAfter() {
        return this.enableAfter;
    }

    public boolean isEnabledAfter() {
        return this.enableAfter != null && !this.enableAfter.isEmpty();
    }

    public String effectivePatternFor(Object subject) {
        if (!this.hasDynamicPattern()) {
            return this.getPatternString();
        }
        return this.getDynamicPattern(this.getDynamicValue(subject)).pattern();
    }

    public static class RuleConfigBuilder {
        private boolean enabled = true;
        private String errorMessage;
        private String condition;
        private String columnCondition;
        private String pattern;
        private String dynamicValue;
        private List<String> values;
        private Integer maxLength;
        private String enableAfter;

        @JsonProperty(value="enabled")
        public RuleConfigBuilder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @JsonProperty(value="errorMessage")
        public RuleConfigBuilder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @JsonProperty(value="condition")
        public RuleConfigBuilder withCondition(String condition) {
            this.condition = condition;
            return this;
        }

        @JsonProperty(value="columnCondition")
        public RuleConfigBuilder withColumnCondition(String columnCondition) {
            this.columnCondition = columnCondition;
            return this;
        }

        @JsonProperty(value="pattern")
        public RuleConfigBuilder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @JsonProperty(value="dynamicValue")
        public RuleConfigBuilder withDynamicValue(String dynamicValue) {
            this.dynamicValue = dynamicValue;
            return this;
        }

        @JsonProperty(value="values")
        public RuleConfigBuilder withValues(List<String> values) {
            this.values = values;
            return this;
        }

        public RuleConfigBuilder withValues(String ... values) {
            return this.withValues(Arrays.asList(values));
        }

        @JsonProperty(value="maxLength")
        public RuleConfigBuilder withMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @JsonProperty(value="enableAfter")
        public RuleConfigBuilder withEnableAfter(String enableAfter) {
            this.enableAfter = enableAfter;
            return this;
        }

        public RuleConfig build() {
            return new RuleConfig(this);
        }
    }
}

