/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.report;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.report.AbstractReporter;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import io.github.liquibaselinter.report.TextReporter;
import java.io.PrintWriter;
import java.util.List;

public class ConsoleReporter
extends TextReporter {
    public static final String NAME = "console";

    public ConsoleReporter(ReporterConfig config) {
        super(config);
    }

    @Override
    protected void process(Report report, List<ReportItem> items) {
        PrintWriter writer = new PrintWriter(System.out);
        this.printReport(writer, report, items);
        writer.flush();
    }

    @Override
    protected void printItemTypeHeader(PrintWriter output, ReportItem.ReportItemType type) {
        this.printItemTypeName(output, type);
        output.println();
    }

    @Override
    protected void printItemTypeSummary(PrintWriter output, ReportItem.ReportItemType type, List<ReportItem> items) {
        output.append('\t');
        if (items.isEmpty()) {
            output.print(type.name());
        } else {
            this.printItemTypeName(output, type);
        }
        output.append(": ").println(items.size());
    }

    protected void printItemTypeName(PrintWriter output, ReportItem.ReportItemType type) {
        output.print(type.name());
    }

    @Override
    protected void printSummaryDisabledRules(PrintWriter output, Report report) {
        output.append('\t');
        output.print("DISABLED");
        output.append(": ").println(ConsoleReporter.countDisabledRules(report));
    }

    @AutoService(value={Reporter.Factory.class})
    public static class Factory
    extends AbstractReporter.Factory<ConsoleReporter> {
        public Factory() {
            super(ConsoleReporter.NAME);
        }
    }
}

