/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.config;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.github.liquibaselinter.config.Config;
import io.github.liquibaselinter.report.ConsoleReporter;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;

public final class ConfigLoader {
    public static final String LQLINT_CONFIG = "/lqlint.json";
    public static final String LQLINT_CONFIG_CLASSPATH = "lqlint.json";
    public static final String LQLINT_CONFIG_PATH_PROPERTY = "lqlint.config.path";

    private ConfigLoader() {
    }

    public static Config load(ResourceAccessor resourceAccessor) {
        List configPaths = Stream.of(System.getProperty(LQLINT_CONFIG_PATH_PROPERTY), LQLINT_CONFIG, LQLINT_CONFIG_CLASSPATH).filter(Objects::nonNull).collect(Collectors.toList());
        for (String configPath : configPaths) {
            Config config = ConfigLoader.loadConfig(resourceAccessor, configPath);
            if (config == null) continue;
            return config.combineWith(ConfigLoader.defaultConfig());
        }
        throw new UnexpectedLiquibaseException("Failed to load any liquibase-linter configuration from locations: " + String.join((CharSequence)", ", configPaths));
    }

    private static Config defaultConfig() {
        ImmutableListMultimap.Builder reportingConfigBuilder = new ImmutableListMultimap.Builder();
        reportingConfigBuilder.put((Object)"console", (Object)new ConsoleReporter(((ReporterConfig.Builder)ReporterConfig.builder().withEnabled(true)).build()));
        return new Config.Builder().withReporting((ListMultimap<String, Reporter>)reportingConfigBuilder.build()).build();
    }

    public static Config loadConfig(ResourceAccessor resourceAccessor, String path) {
        try {
            Resource resource = resourceAccessor.get(path);
            if (resource == null || !resource.exists()) {
                return null;
            }
            Config config = Config.fromInputStream(resource.openInputStream());
            if (config != null) {
                return ConfigLoader.loadImports(resourceAccessor, config);
            }
        }
        catch (IOException exception) {
            throw new UnexpectedLiquibaseException("Failed to load liquibase-linter config file: " + path, (Throwable)exception);
        }
        return null;
    }

    private static Config loadImports(ResourceAccessor resourceAccessor, Config config) {
        List<String> imports = Collections.unmodifiableList(config.getImports());
        Config combinedImportConfig = new Config.Builder().build();
        for (String importPath : imports) {
            Config importedConfig = ConfigLoader.loadConfig(resourceAccessor, importPath);
            if (importedConfig == null) {
                throw new UnexpectedLiquibaseException("Failed to load imported liquibase-linter config file: " + importPath);
            }
            combinedImportConfig = combinedImportConfig.mergeWith(importedConfig);
        }
        return config.combineWith(combinedImportConfig);
    }
}

