/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.report;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.report.AbstractReporter;
import io.github.liquibaselinter.report.ConsoleReporter;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import java.io.PrintWriter;
import java.util.List;
import org.jline.jansi.Ansi;
import org.jline.jansi.AnsiConsole;

public class AnsiConsoleReporter
extends ConsoleReporter {
    public static final String NAME = "ansi-console";

    public AnsiConsoleReporter(ReporterConfig config) {
        super(config);
    }

    @Override
    protected void process(Report report, List<ReportItem> items) {
        this.installAnsi();
        super.process(report, items);
        this.uninstallAnsi();
    }

    @Override
    protected void printItemTypeName(PrintWriter output, ReportItem.ReportItemType type) {
        switch (type) {
            case ERROR: {
                this.printColoured(output, Ansi.Color.RED, type.name());
                break;
            }
            case IGNORED: {
                this.printColoured(output, Ansi.Color.YELLOW, type.name());
                break;
            }
            case PASSED: {
                this.printColoured(output, Ansi.Color.GREEN, type.name());
                break;
            }
            default: {
                super.printItemTypeName(output, type);
            }
        }
    }

    private void printColoured(PrintWriter output, Ansi.Color colour, String line) {
        output.print(Ansi.ansi().reset().fg(colour).a(line).reset().toString());
    }

    @Override
    protected void printSummaryDisabledRules(PrintWriter output, Report report) {
        long disabled = AnsiConsoleReporter.countDisabledRules(report);
        output.append('\t');
        if (disabled > 0L) {
            this.printColoured(output, Ansi.Color.MAGENTA, "DISABLED");
        } else {
            output.print("DISABLED");
        }
        output.append(": ").println(disabled);
    }

    protected void installAnsi() {
        AnsiConsole.systemInstall();
    }

    protected void uninstallAnsi() {
        AnsiConsole.systemUninstall();
    }

    @AutoService(value={Reporter.Factory.class})
    public static class Factory
    extends AbstractReporter.Factory<AnsiConsoleReporter> {
        public Factory() {
            super(AnsiConsoleReporter.NAME);
        }
    }
}

