/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.report;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.report.AbstractReporter;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import io.github.liquibaselinter.report.TextReporter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MarkdownReporter
extends TextReporter {
    public static final String NAME = "markdown";
    private static final String[] HEADERS = new String[]{"Change Set", "Status", "Rule", "Message"};
    private static final int COL_CHANGE_SET = 0;
    private static final int COL_STATUS = 1;
    private static final int COL_RULE = 2;
    private static final int COL_MESSAGE = 3;

    public MarkdownReporter(ReporterConfig config) {
        super(config, "md");
    }

    @Override
    protected void printChangeLogHeader(PrintWriter output, String fileName) {
        output.append("# ");
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            output.println("*Other*");
        } else {
            output.append('`').append(fileName).println('`');
        }
    }

    @Override
    protected void printByChangeSet(PrintWriter output, List<ReportItem> items) {
        String[][] table = new String[items.size()][HEADERS.length];
        int[] maxWidth = Arrays.stream(HEADERS).mapToInt(String::length).toArray();
        int row = 0;
        SortedMap itemsByChangeSet = items.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getChangeSetId()).map(String::trim).orElse(""), TreeMap::new, Collectors.toList()));
        for (Map.Entry changeSetEntry : itemsByChangeSet.entrySet()) {
            String changeSet = MarkdownReporter.tableCellFormat(StringUtils.isEmpty((CharSequence)((CharSequence)changeSetEntry.getKey())) ? "*none*" : (String)changeSetEntry.getKey());
            maxWidth[0] = Math.max(maxWidth[0], MarkdownReporter.tableCellWidth(changeSet));
            SortedMap itemsByType = ((List)changeSetEntry.getValue()).stream().collect(Collectors.groupingBy(ReportItem::getType, TreeMap::new, Collectors.toList()));
            for (Map.Entry typedEntry : itemsByType.entrySet()) {
                String status = MarkdownReporter.tableCellFormat(((ReportItem.ReportItemType)((Object)typedEntry.getKey())).name());
                maxWidth[1] = Math.max(maxWidth[1], MarkdownReporter.tableCellWidth(status));
                for (ReportItem item2 : (List)typedEntry.getValue()) {
                    table[row][0] = changeSet;
                    table[row][1] = status;
                    table[row][2] = MarkdownReporter.tableCellFormat(item2.getRule());
                    table[row][3] = MarkdownReporter.tableCellFormat(item2.getMessage());
                    maxWidth[2] = Math.max(maxWidth[2], MarkdownReporter.tableCellWidth(table[row][2]));
                    maxWidth[3] = Math.max(maxWidth[3], MarkdownReporter.tableCellWidth(table[row][3]));
                    status = "";
                    changeSet = "";
                    ++row;
                }
            }
        }
        this.printTableHeader(output, maxWidth);
        this.printTableBody(output, table, maxWidth);
    }

    private static String tableCellFormat(String value) {
        return Optional.ofNullable(value).map(String::trim).map(cell -> cell.replace("\n", "<br>")).orElse("");
    }

    private static int tableCellWidth(String value) {
        String trimmed = Optional.ofNullable(value).map(String::trim).orElse("");
        return Arrays.stream(trimmed.split("<br>")).map(String::length).max(Integer::compare).get();
    }

    private void printTableHeader(PrintWriter output, int[] maxWidth) {
        this.printTableRow(output, HEADERS, maxWidth);
        for (int col = 0; col < HEADERS.length; ++col) {
            output.append("|-").append(StringUtils.repeat((String)"-", (int)maxWidth[col])).append('-');
        }
        output.println('|');
    }

    private void printTableBody(PrintWriter output, String[][] table, int[] maxWidth) {
        for (String[] row : table) {
            this.printTableRow(output, row, maxWidth);
        }
    }

    private void printTableRow(PrintWriter output, String[] row, int[] maxWidth) {
        for (int col = 0; col < row.length; ++col) {
            output.append("| ").append(StringUtils.rightPad((String)row[col], (int)maxWidth[col], (char)' ')).append(' ');
        }
        output.println('|');
    }

    @Override
    protected void printSummaryHeader(PrintWriter output, Report report) {
        output.println("# Summary");
    }

    @Override
    protected void printItemTypeSummary(PrintWriter output, ReportItem.ReportItemType type, List<ReportItem> items) {
        output.append("* ").append(type.name()).append(": ").println(items.size());
    }

    @Override
    protected void printSummaryDisabledRules(PrintWriter output, Report report) {
        output.append("* DISABLED: ").println(MarkdownReporter.countDisabledRules(report));
    }

    @AutoService(value={Reporter.Factory.class})
    public static class Factory
    extends AbstractReporter.Factory<MarkdownReporter> {
        public Factory() {
            super(MarkdownReporter.NAME);
        }
    }
}

