/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules;

import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.rules.PatternChecker;
import java.util.Optional;
import liquibase.change.ColumnConfig;

public class LintRuleChecker {
    private final RuleConfig ruleConfig;
    private final PatternChecker patternChecker;

    public LintRuleChecker(RuleConfig ruleConfig) {
        this.ruleConfig = ruleConfig;
        this.patternChecker = ruleConfig.hasPattern() ? new PatternChecker(ruleConfig) : null;
    }

    public boolean checkBlank(String value) {
        return value != null && !value.isEmpty();
    }

    public boolean checkNotBlank(String value) {
        return value == null || value.isEmpty();
    }

    public boolean checkPattern(String value, Object subject) {
        return Optional.ofNullable(this.patternChecker).map(checker -> checker.check(value, subject)).orElse(false);
    }

    public boolean checkMandatoryPattern(String value, Object subject) {
        return this.checkNotBlank(value) || this.patternChecker.check(value, subject);
    }

    public boolean checkMaxLength(String value) {
        return value != null && value.length() > this.ruleConfig.getMaxLength();
    }

    public boolean columnConditionIsSatisfied(ColumnConfig column) {
        return this.ruleConfig.getConditionalColumnExpression().map(expression -> (Boolean)expression.getValue((Object)column, Boolean.TYPE)).orElse(true);
    }
}

