/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.rules.ChangeSetRule;
import io.github.liquibaselinter.rules.Changes;
import io.github.liquibaselinter.rules.LintRuleViolationGenerator;
import io.github.liquibaselinter.rules.RuleViolation;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;

@AutoService(value={ChangeSetRule.class})
public class SeparateDDLChangesRule
implements ChangeSetRule {
    private static final String NAME = "separate-ddl-context";
    private static final String DEFAULT_MESSAGE = "Should have a ddl changes under ddl contexts";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<RuleViolation> check(ChangeSet changeSet, RuleConfig ruleConfig) {
        if (this.isInvalid(changeSet, ruleConfig)) {
            LintRuleViolationGenerator violations = new LintRuleViolationGenerator(DEFAULT_MESSAGE, ruleConfig);
            return Collections.singleton(violations.withFormattedMessage(new Object[0]));
        }
        return Collections.emptyList();
    }

    public boolean isInvalid(ChangeSet changeSet, RuleConfig ruleConfig) {
        ContextExpression contextExpression = changeSet.getContextFilter();
        if (contextExpression == null || contextExpression.getContexts().isEmpty()) {
            return false;
        }
        Set contexts = contextExpression.getContexts();
        for (Change change : changeSet.getChanges()) {
            if (Changes.isDDL(change)) {
                for (String context : contexts) {
                    if (ruleConfig.getPattern().map(pattern -> pattern.matcher(context).matches()).orElse(true).booleanValue()) continue;
                    return true;
                }
                continue;
            }
            if (!Changes.isDML(change)) continue;
            for (String context : contexts) {
                if (!ruleConfig.getPattern().map(pattern -> pattern.matcher(context).matches()).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

