/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.config;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.github.liquibaselinter.config.Config;
import io.github.liquibaselinter.report.ConsoleReporter;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.ResourceAccessor;

public final class ConfigLoader {
    public static final String LQLINT_CONFIG = "/lqlint.json";
    public static final String LQLINT_CONFIG_CLASSPATH = "lqlint.json";
    public static final String LQLINT_CONFIG_PATH_PROPERTY = "lqlint.config.path";

    private ConfigLoader() {
    }

    public static Config load(ResourceAccessor resourceAccessor) {
        List configPaths = Stream.of(System.getProperty(LQLINT_CONFIG_PATH_PROPERTY), LQLINT_CONFIG, LQLINT_CONFIG_CLASSPATH).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            for (String configPath : configPaths) {
                Config config = ConfigLoader.loadConfig(resourceAccessor, configPath);
                if (config == null) continue;
                return config.combineWith(ConfigLoader.defaultConfig());
            }
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException("Failed to load lq lint config file", (Throwable)e);
        }
        throw new UnexpectedLiquibaseException("Failed to load lq lint config file");
    }

    private static Config defaultConfig() {
        ImmutableListMultimap.Builder reportingConfigBuilder = new ImmutableListMultimap.Builder();
        reportingConfigBuilder.put((Object)"console", (Object)new ConsoleReporter(((ReporterConfig.Builder)ReporterConfig.builder().withEnabled(true)).build()));
        return new Config.Builder().withReporting((ListMultimap<String, Reporter>)reportingConfigBuilder.build()).build();
    }

    public static Config loadConfig(ResourceAccessor resourceAccessor, String path) throws IOException {
        try (InputStream stream = resourceAccessor.openStream(null, path);){
            Config config;
            if (stream != null && (config = Config.fromInputStream(stream)) != null) {
                Config config2 = ConfigLoader.loadImports(resourceAccessor, config);
                return config2;
            }
        }
        return null;
    }

    private static Config loadImports(ResourceAccessor resourceAccessor, Config config) {
        List<String> imports = Collections.unmodifiableList(config.getImports());
        Config combinedImportConfig = new Config.Builder().build();
        for (String importPath : imports) {
            try {
                Config importedConfig = ConfigLoader.loadConfig(resourceAccessor, importPath);
                combinedImportConfig = combinedImportConfig.mergeWith(importedConfig);
            }
            catch (IOException | NullPointerException e) {
                throw new UnexpectedLiquibaseException("Failed to load imported lq lint config file: " + importPath, (Throwable)e);
            }
        }
        return config.combineWith(combinedImportConfig);
    }
}

