/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.report;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableSet;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.exception.UnexpectedLiquibaseException;
import org.springframework.core.GenericTypeResolver;

public abstract class AbstractReporter
implements Reporter {
    private final ReporterConfig config;
    private final String path;
    private final Set<ReportItem.ReportItemType> filter;

    protected AbstractReporter(ReporterConfig config, String defaultPathExtension) {
        this.config = config;
        this.path = Optional.ofNullable(config.getPath()).orElse("./target/lqlint-report." + defaultPathExtension);
        this.filter = (Set)Optional.ofNullable(config.getFilter()).map(ImmutableSet::copyOf).orElse(ImmutableSet.of((Object)((Object)ReportItem.ReportItemType.ERROR), (Object)((Object)ReportItem.ReportItemType.IGNORED)));
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void processReport(Report report) {
        List<ReportItem> filteredItems = report.getItems().stream().filter(item -> this.filter.contains((Object)item.getType())).collect(Collectors.toList());
        this.process(report, filteredItems);
    }

    protected void process(Report report, List<ReportItem> items) {
        try (FileWriter writer = new FileWriter(this.path);){
            this.printReport(new PrintWriter(writer), report, items);
            writer.flush();
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException("Unable to write text report", (Throwable)e);
        }
    }

    protected abstract void printReport(PrintWriter var1, Report var2, List<ReportItem> var3);

    protected static long countDisabledRules(Report report) {
        return report.getConfig().getRules().values().stream().filter(rule -> !rule.isEnabled()).count();
    }

    public static class Factory<R extends Reporter>
    extends BaseFactory<R, ReporterConfig> {
        protected Factory(String name) {
            super(name);
        }
    }

    public static abstract class BaseFactory<R extends Reporter, C extends ReporterConfig>
    implements Reporter.Factory<R, C> {
        private final String name;
        private final Class<? extends R> reporterClass;
        private final Class<? extends C> configClass;
        private final Class<?> configBuilderClass;

        protected BaseFactory(String name) {
            this.name = name;
            Class[] factoryTypes = GenericTypeResolver.resolveTypeArguments(this.getClass(), Reporter.Factory.class);
            this.reporterClass = factoryTypes[0];
            this.configClass = factoryTypes[1];
            this.configBuilderClass = Optional.ofNullable(this.configClass.getAnnotation(JsonDeserialize.class)).map(JsonDeserialize::builder).orElseThrow(() -> new UnexpectedLiquibaseException("Cannot find builder for " + this.configClass));
        }

        @Override
        public boolean supports(String name) {
            return this.name.equals(name);
        }

        @Override
        public Class<? extends C> getConfigClass() {
            return this.configClass;
        }

        @Override
        public R create(C config) {
            return this.createReporter((ReporterConfig)config);
        }

        @Override
        public R create(boolean enabled) {
            return this.createReporter(((ReporterConfig.BaseBuilder)this.newConfigBuilder().withEnabled(enabled)).build());
        }

        @Override
        public R create(String path) {
            return this.createReporter(((ReporterConfig.BaseBuilder)this.newConfigBuilder().withPath(path)).build());
        }

        protected R createReporter(ReporterConfig config) {
            try {
                return (R)((Reporter)this.reporterClass.getConstructor(this.configClass).newInstance(config));
            }
            catch (ReflectiveOperationException e) {
                throw new UnexpectedLiquibaseException("Cannot instantiate reporter of type " + this.reporterClass, (Throwable)e);
            }
        }

        private ReporterConfig.BaseBuilder<?> newConfigBuilder() {
            try {
                return (ReporterConfig.BaseBuilder)this.configBuilderClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnexpectedLiquibaseException("Cannot instantiate builder for " + this.configClass, (Throwable)e);
            }
        }
    }
}

