/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.report;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.report.AbstractReporter;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import io.github.liquibaselinter.report.TextReporter;
import java.io.PrintWriter;
import java.util.List;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class ConsoleReporter
extends TextReporter {
    public static final String NAME = "console";

    public ConsoleReporter(ReporterConfig config) {
        super(config);
    }

    @Override
    protected void process(Report report, List<ReportItem> items) {
        this.installAnsi();
        try (PrintWriter writer = new PrintWriter(System.out);){
            this.printReport(writer, report, items);
            writer.flush();
        }
        this.uninstallAnsi();
    }

    @Override
    protected void printItemTypeHeader(PrintWriter output, ReportItem.ReportItemType type) {
        this.printItemTypeName(output, type);
        output.println();
    }

    @Override
    protected void printItemTypeSummary(PrintWriter output, ReportItem.ReportItemType type, List<ReportItem> items) {
        output.append('\t');
        if (items.isEmpty()) {
            output.print(type.name());
        } else {
            this.printItemTypeName(output, type);
        }
        output.append(": ").println(items.size());
    }

    private void printItemTypeName(PrintWriter output, ReportItem.ReportItemType type) {
        switch (type) {
            case ERROR: {
                this.printColoured(output, Ansi.Color.RED, type.name());
                break;
            }
            case IGNORED: {
                this.printColoured(output, Ansi.Color.YELLOW, type.name());
                break;
            }
            case PASSED: {
                this.printColoured(output, Ansi.Color.GREEN, type.name());
                break;
            }
            default: {
                super.printItemTypeHeader(output, type);
            }
        }
    }

    private void printColoured(PrintWriter output, Ansi.Color colour, String line) {
        output.print(Ansi.ansi().reset().fg(colour).a(line).reset().toString());
    }

    @Override
    protected void printSummaryDisabledRules(PrintWriter output, Report report) {
        long disabled = ConsoleReporter.countDisabledRules(report);
        output.append('\t');
        if (disabled > 0L) {
            output.print(Ansi.ansi().reset().fg(Ansi.Color.MAGENTA).a("DISABLED").reset().toString());
        } else {
            output.print("DISABLED");
        }
        output.append(": ").println(disabled);
    }

    protected void installAnsi() {
        AnsiConsole.systemInstall();
    }

    protected void uninstallAnsi() {
        AnsiConsole.systemUninstall();
    }

    @AutoService(value={Reporter.Factory.class})
    public static class Factory
    extends AbstractReporter.Factory<ConsoleReporter> {
        public Factory() {
            super(ConsoleReporter.NAME);
        }
    }
}

