/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules;

import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.rules.LintRule;
import io.github.liquibaselinter.rules.checker.PatternChecker;
import java.util.Arrays;
import java.util.Optional;

public abstract class AbstractLintRule
implements LintRule {
    private final String name;
    private final String message;
    protected RuleConfig ruleConfig;
    private PatternChecker patternChecker;

    protected AbstractLintRule(String name, String message) {
        this.name = name;
        this.message = message;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void configure(RuleConfig ruleConfig) {
        this.ruleConfig = ruleConfig;
        this.patternChecker = ruleConfig.hasPattern() ? new PatternChecker(ruleConfig) : null;
    }

    protected RuleConfig getConfig() {
        return this.ruleConfig;
    }

    protected String getPatternForMessage(Object subject) {
        return this.getConfig().hasDynamicPattern() ? this.getConfig().getDynamicPattern(this.getConfig().getDynamicValue(subject)).pattern() : this.getConfig().getPatternString();
    }

    protected boolean checkBlank(String value) {
        return value != null && !value.isEmpty();
    }

    protected boolean checkNotBlank(String value) {
        return value == null || value.isEmpty();
    }

    protected boolean checkPattern(String value, Object subject) {
        return Optional.ofNullable(this.patternChecker).map(checker -> checker.check(value, subject)).orElse(false);
    }

    protected boolean checkMandatoryPattern(String value, Object subject) {
        return this.checkNotBlank(value) || this.patternChecker.check(value, subject);
    }

    protected boolean checkMaxLength(String value) {
        return value != null && value.length() > this.getConfig().getMaxLength();
    }

    @Override
    public String getMessage() {
        return this.getMessageTemplate();
    }

    private String getMessageTemplate() {
        return Optional.ofNullable(this.ruleConfig.getErrorMessage()).orElse(this.message);
    }

    protected String formatMessage(Object ... stuff) {
        return String.format(this.getMessageTemplate(), Arrays.stream(stuff).map(thing -> Optional.ofNullable(thing).orElse("")).toArray());
    }
}

