/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules;

import io.github.liquibaselinter.config.RuleConfig;
import java.util.Optional;
import liquibase.Contexts;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;

public final class ConditionHelper {
    private ConditionHelper() {
    }

    public static boolean evaluateCondition(RuleConfig ruleConfig, Change change) {
        return ruleConfig.getConditionalExpression().map(expression -> (Boolean)expression.getValue((Object)new ConditionContext(change.getChangeSet().getChangeLog(), change.getChangeSet(), change), Boolean.TYPE)).orElse(true);
    }

    public static boolean evaluateCondition(RuleConfig ruleConfig, ChangeSet changeSet) {
        return ruleConfig.getConditionalExpression().map(expression -> (Boolean)expression.getValue((Object)new ConditionContext(changeSet.getChangeLog(), changeSet, null), Boolean.TYPE)).orElse(true);
    }

    public static boolean evaluateCondition(RuleConfig ruleConfig, DatabaseChangeLog databaseChangeLog) {
        return ruleConfig.getConditionalExpression().map(expression -> (Boolean)expression.getValue((Object)new ConditionContext(databaseChangeLog, null, null), Boolean.TYPE)).orElse(true);
    }

    private static final class ConditionContext {
        private final DatabaseChangeLog changeLog;
        private final ChangeSet changeSet;
        private final Change change;

        private ConditionContext(DatabaseChangeLog changeLog, ChangeSet changeSet, Change change) {
            this.changeLog = changeLog;
            this.changeSet = changeSet;
            this.change = change;
        }

        public DatabaseChangeLog getChangeLog() {
            return this.changeLog;
        }

        public ChangeSet getChangeSet() {
            return this.changeSet;
        }

        public Change getChange() {
            return this.change;
        }

        public boolean matchesContext(String ... toMatch) {
            return Optional.ofNullable(this.changeSet).map(ChangeSet::getContexts).map(contexts -> !contexts.isEmpty() && contexts.matches(new Contexts(toMatch))).orElse(false);
        }
    }
}

