/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.rules.AbstractLintRule;
import io.github.liquibaselinter.rules.ChangeRule;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.change.core.AddUniqueConstraintChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.MergeColumnChange;
import liquibase.change.core.RenameColumnChange;
import liquibase.change.core.RenameViewChange;

public class ObjectNameRules {
    private static boolean doesSupport(Change change) {
        return !ObjectNameRules.getObjectNames(change).isEmpty();
    }

    private static Collection<String> getObjectNames(Change change) {
        if (change instanceof AddColumnChange) {
            return ((AddColumnChange)change).getColumns().stream().map(ColumnConfig::getName).collect(Collectors.toList());
        }
        if (change instanceof AddForeignKeyConstraintChange) {
            return Collections.singletonList(((AddForeignKeyConstraintChange)change).getConstraintName());
        }
        if (change instanceof AddPrimaryKeyChange) {
            return Collections.singletonList(((AddPrimaryKeyChange)change).getConstraintName());
        }
        if (change instanceof AddUniqueConstraintChange) {
            return Collections.singletonList(((AddUniqueConstraintChange)change).getConstraintName());
        }
        if (change instanceof CreateTableChange) {
            return ((CreateTableChange)change).getColumns().stream().map(ColumnConfig::getName).collect(Collectors.toList());
        }
        if (change instanceof MergeColumnChange) {
            return Collections.singletonList(((MergeColumnChange)change).getFinalColumnName());
        }
        if (change instanceof RenameColumnChange) {
            return Collections.singletonList(((RenameColumnChange)change).getNewColumnName());
        }
        if (change instanceof RenameViewChange) {
            return Collections.singletonList(((RenameViewChange)change).getNewViewName());
        }
        if (change instanceof CreateViewChange) {
            return Collections.singletonList(((CreateViewChange)change).getViewName());
        }
        if (change instanceof CreateIndexChange) {
            return Collections.singletonList(((CreateIndexChange)change).getIndexName());
        }
        return Collections.emptyList();
    }

    @AutoService(value={ChangeRule.class})
    public static class ObjectNameLengthRule
    extends AbstractLintRule
    implements ChangeRule {
        private static final String NAME = "object-name-length";
        private static final String MESSAGE = "Object name '%s' must be less than %d characters";

        public ObjectNameLengthRule() {
            super(NAME, MESSAGE);
        }

        @Override
        public boolean supports(Change change) {
            return ObjectNameRules.doesSupport(change);
        }

        @Override
        public boolean invalid(Change change) {
            return ObjectNameRules.getObjectNames(change).stream().anyMatch(this::checkMaxLength);
        }

        @Override
        public String getMessage(Change change) {
            String joined = ObjectNameRules.getObjectNames(change).stream().filter(this::checkMaxLength).collect(Collectors.joining(","));
            return this.formatMessage(joined, this.getConfig().getMaxLength());
        }
    }

    @AutoService(value={ChangeRule.class})
    public static class ObjectNameRule
    extends AbstractLintRule
    implements ChangeRule {
        private static final String NAME = "object-name";
        private static final String MESSAGE = "Object name does not follow pattern";

        public ObjectNameRule() {
            super(NAME, MESSAGE);
        }

        @Override
        public boolean supports(Change change) {
            return ObjectNameRules.doesSupport(change);
        }

        @Override
        public boolean invalid(Change change) {
            return ObjectNameRules.getObjectNames(change).stream().anyMatch(objectName -> this.checkMandatoryPattern((String)objectName, change));
        }

        @Override
        public String getMessage(Change change) {
            String joined = ObjectNameRules.getObjectNames(change).stream().filter(objectName -> this.checkMandatoryPattern((String)objectName, change)).collect(Collectors.joining(","));
            return this.formatMessage(joined, this.getConfig().getPatternString());
        }
    }
}

