/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.rules.AbstractLintRule;
import io.github.liquibaselinter.rules.ChangeSetRule;
import io.github.liquibaselinter.rules.Changes;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;

@AutoService(value={ChangeSetRule.class})
public class SeparateDDLChangesRule
extends AbstractLintRule
implements ChangeSetRule {
    private static final String NAME = "separate-ddl-context";
    private static final String MESSAGE = "Should have a ddl changes under ddl contexts";

    public SeparateDDLChangesRule() {
        super(NAME, MESSAGE);
    }

    @Override
    public boolean invalid(ChangeSet changeSet) {
        ContextExpression contextExpression = changeSet.getContexts();
        if (contextExpression != null && !contextExpression.getContexts().isEmpty()) {
            Set contexts = contextExpression.getContexts();
            for (Change change : changeSet.getChanges()) {
                if (Changes.isDDL(change)) {
                    for (String context : contexts) {
                        if (this.getConfig().getPattern().map(pattern -> pattern.matcher(context).matches()).orElse(true).booleanValue()) continue;
                        return true;
                    }
                    continue;
                }
                if (!Changes.isDML(change)) continue;
                for (String context : contexts) {
                    if (!this.getConfig().getPattern().map(pattern -> pattern.matcher(context).matches()).orElse(false).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

