/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.mavenplugin;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.github.liquibaselinter.ChangeLogLinter;
import io.github.liquibaselinter.ChangeLogLintingException;
import io.github.liquibaselinter.config.Config;
import io.github.liquibaselinter.config.ConfigLoader;
import io.github.liquibaselinter.mavenplugin.LiquibaseMavenLogService;
import io.github.liquibaselinter.mavenplugin.MavenConsoleReporter;
import io.github.liquibaselinter.report.ConsoleReporter;
import io.github.liquibaselinter.report.ReporterConfig;
import java.io.File;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CheckMojo
extends AbstractMojo {
    @Parameter(property="changeLogFile", required=true)
    private String changeLogFile;
    @Parameter(property="configurationFile", defaultValue="src/test/resources/lqlint.json", required=true)
    private String configurationFile;
    @Inject
    private MavenProject mavenProject;

    public void execute() throws MojoFailureException, MojoExecutionException {
        try (ResourceAccessor resourceAccessor = this.buildResourceAccessor();){
            Scope.child(this.setUpLiquibaseLogging(), () -> {
                Liquibase liquibase = CheckMojo.createLiquibase(this.relativePathOf(this.changeLogFile), resourceAccessor);
                DatabaseChangeLog databaseChangeLog = liquibase.getDatabaseChangeLog();
                Config linterConfig = this.linterConfiguration(resourceAccessor);
                new ChangeLogLinter(resourceAccessor, linterConfig).lintChangeLog(databaseChangeLog);
            });
        }
        catch (ChangeLogLintingException lintingException) {
            throw new MojoFailureException((Throwable)lintingException);
        }
        catch (Exception e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private Map<String, Object> setUpLiquibaseLogging() {
        HashMap<String, Object> scopeAttrs = new HashMap<String, Object>();
        scopeAttrs.put(Scope.Attr.logService.name(), (Object)new LiquibaseMavenLogService(this.getLog()));
        return scopeAttrs;
    }

    private Config linterConfiguration(ResourceAccessor resourceAccessor) throws MojoExecutionException {
        Config userConfig = ConfigLoader.loadConfig((ResourceAccessor)resourceAccessor, (String)this.relativePathOf(this.configurationFile));
        if (userConfig == null) {
            throw new MojoExecutionException("Unable to load liquibase-linter configuration at " + this.configurationFile);
        }
        Config linterConfig = userConfig.mergeWith(this.defaultMavenLinterConfig());
        return linterConfig;
    }

    private Config defaultMavenLinterConfig() {
        ImmutableListMultimap.Builder reportingConfigBuilder = new ImmutableListMultimap.Builder();
        reportingConfigBuilder.put((Object)"mavenReporter", (Object)new MavenConsoleReporter(this.getLog()));
        reportingConfigBuilder.put((Object)"console", (Object)new ConsoleReporter(((ReporterConfig.Builder)ReporterConfig.builder().withEnabled(false)).build()));
        return new Config.Builder().withReporting((ListMultimap)reportingConfigBuilder.build()).build();
    }

    private String relativePathOf(String changeLogFile) {
        return changeLogFile.replace(this.mavenProject.getBasedir().getAbsolutePath(), "");
    }

    /*
     * Exception decompiling
     */
    private ResourceAccessor buildResourceAccessor() throws MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ClassLoader classLoaderIncludingProjectClasspath() throws MojoExecutionException {
        try {
            URL[] urls = (URL[])this.mavenProject.getCompileClasspathElements().stream().map(File::new).map(CheckMojo.fileToURL()).toArray(URL[]::new);
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to create project classloader", exception);
        }
    }

    private static Function<File, URL> fileToURL() {
        return file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException exception) {
                throw new UncheckedIOException(exception);
            }
        };
    }

    private static Liquibase createLiquibase(String changeLogFile, ResourceAccessor resourceAccessor) throws LiquibaseException {
        try (OfflineConnection connection = new OfflineConnection("offline:h2", resourceAccessor);){
            Liquibase liquibase = new Liquibase(changeLogFile, resourceAccessor, (DatabaseConnection)connection);
            return liquibase;
        }
    }
}

