/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.mavenplugin;

import io.github.liquibaselinter.report.EmptyLastComparator;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.report.Reporter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

class MavenConsoleReporter
implements Reporter {
    private final Log log;

    public MavenConsoleReporter(Log log) {
        this.log = log;
    }

    public void processReport(Report report) {
        Set<ReportItem> errors = report.getItems().stream().filter(reportItem -> reportItem.getType() == ReportItem.ReportItemType.ERROR).collect(Collectors.toSet());
        if (errors.isEmpty()) {
            this.log.info((CharSequence)"No violation found");
            return;
        }
        this.log.error((CharSequence)(errors.size() + " violation(s) found"));
        this.printByChangeLogFile(errors);
    }

    private void printByChangeLogFile(Collection<ReportItem> items) {
        items.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getFilePath()).map(String::trim).orElse(""))).entrySet().stream().sorted(Map.Entry.comparingByKey(new EmptyLastComparator())).forEach(entry -> this.printChangeLogFile((String)entry.getKey(), (List)entry.getValue()));
    }

    private void printChangeLogFile(String fileName, List<ReportItem> items) {
        this.printChangeLogHeader(fileName);
        this.printByChangeSet(items);
    }

    private void printChangeLogHeader(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            this.println("Other");
        } else {
            this.println(fileName);
        }
    }

    private void printByChangeSet(List<ReportItem> items) {
        items.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getChangeSetId()).map(String::trim).orElse(""))).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> this.printChangeSet((String)entry.getKey(), (List)entry.getValue()));
    }

    private void printChangeSet(String changeSetId, List<ReportItem> items) {
        this.printChangeSetHeader(changeSetId);
        items.forEach(this::printItemDetail);
    }

    private void printChangeSetHeader(String changeSetId) {
        if (!changeSetId.isEmpty()) {
            this.println("\t", "changeSet '", changeSetId, "'");
        }
    }

    private void printItemDetail(ReportItem item) {
        this.println("\t\t'", item.getRule(), "': ", this.indentMessage(item.getMessage()));
    }

    private String indentMessage(String message) {
        return message.replace("\n", "\n\t\t");
    }

    private void println(String ... content) {
        this.log.error((CharSequence)String.join((CharSequence)"", content));
    }

    public boolean isEnabled() {
        return true;
    }
}

