/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jdatepicker.ComponentFormatDefaults;

public final class ComponentTextDefaults {
    private static ComponentTextDefaults instance;
    private Properties texts = this.toProperties(ResourceBundle.getBundle("org.jdatepicker.i18n.Text", Locale.getDefault()));

    public static ComponentTextDefaults getInstance() {
        if (instance == null) {
            instance = new ComponentTextDefaults();
        }
        return instance;
    }

    private ComponentTextDefaults() {
    }

    private Properties toProperties(ResourceBundle resource) {
        Properties result = new Properties();
        Enumeration<String> keys = resource.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.put(key, resource.getString(key));
        }
        return result;
    }

    public String getText(Key key) {
        ComponentFormatDefaults defaults;
        Calendar c;
        String text = this.texts.getProperty(key.getProperty());
        if (text == null && "month".equals(key.getKind())) {
            c = Calendar.getInstance();
            c.set(2, key.getIndex());
            defaults = ComponentFormatDefaults.getInstance();
            DateFormat monthFormat = defaults.getFormat(ComponentFormatDefaults.Key.MONTH_SELECTOR);
            text = monthFormat.format(c.getTime());
        }
        if (text == null && "dow".equals(key.getKind())) {
            c = Calendar.getInstance();
            c.set(7, key.getIndex());
            defaults = ComponentFormatDefaults.getInstance();
            DateFormat dowFormat = defaults.getFormat(ComponentFormatDefaults.Key.DOW_HEADER);
            text = dowFormat.format(c.getTime());
        }
        return text;
    }

    public void setText(Key key, String value) {
        this.texts.setProperty(key.getProperty(), value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        TODAY("text.today", "general"),
        MONTH("text.month", "general"),
        YEAR("text.year", "general"),
        CLEAR("text.clear", "general"),
        JANUARY("text.january", "month", 0),
        FEBRUARY("text.february", "month", 1),
        MARCH("text.march", "month", 2),
        APRIL("text.april", "month", 3),
        MAY("text.may", "month", 4),
        JUNE("text.june", "month", 5),
        JULY("text.july", "month", 6),
        AUGUST("text.august", "month", 7),
        SEPTEMBER("text.september", "month", 8),
        OCTOBER("text.october", "month", 9),
        NOVEMBER("text.november", "month", 10),
        DECEMBER("text.december", "month", 11),
        SUN("text.sun", "dow", 0),
        MON("text.mon", "dow", 1),
        TUE("text.tue", "dow", 2),
        WED("text.wed", "dow", 3),
        THU("text.thu", "dow", 4),
        FRI("text.fri", "dow", 5),
        SAT("text.sat", "dow", 6);

        private String property;
        private String kind;
        private Integer index;

        private Key(String property, String kind) {
            this.property = property;
            this.kind = kind;
        }

        private Key(String property, String kind, Integer index) {
            this.property = property;
            this.kind = kind;
            this.index = index;
        }

        public String getProperty() {
            return this.property;
        }

        public String getKind() {
            return this.kind;
        }

        public Integer getIndex() {
            return this.index;
        }

        public static Key getMonthKey(int index) {
            for (Key key : Key.values()) {
                if (!"month".equals(key.getKind()) || index != key.getIndex()) continue;
                return key;
            }
            return null;
        }

        public static Key getDowKey(int index) {
            for (Key key : Key.values()) {
                if (!"dow".equals(key.getKind()) || index != key.getIndex()) continue;
                return key;
            }
            return null;
        }
    }
}

