/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import org.jdatepicker.JDatePicker;

public class DatePickerKeyListener
implements KeyListener {
    private final JDatePicker datePicker;
    private final Pattern TYPING_1 = Pattern.compile("^(\\d\\d?)\\/?(((\\d\\d?)\\/?)?(\\d{1,4})?\\/?)?");
    private final Pattern TYPING_2 = Pattern.compile("^(\\d{1,4})\\/?(((\\d\\d?)\\/?)?(\\d{1,2})?\\/?)?");
    private final String TYPING_DATE_FORMAT_1 = "dd/MM/yyyy";
    private final String TYPING_DATE_FORMAT_2 = "yyyy/MM/dd";

    public DatePickerKeyListener(JDatePicker owner) {
        this.datePicker = owner;
    }

    public void keyTyped(KeyEvent event) {
        Pattern typing = null;
        if ("dd/MM/yyyy".equals(this.datePicker.getDateFormat())) {
            typing = this.TYPING_1;
        } else if ("yyyy/MM/dd".equals(this.datePicker.getDateFormat())) {
            typing = this.TYPING_2;
        } else {
            return;
        }
        JTextField field = (JTextField)event.getSource();
        char keyChar = event.getKeyChar();
        if (keyChar >= '0' && keyChar <= '9') {
            String input = field.getText();
            int start = field.getSelectionStart();
            int end = field.getSelectionEnd();
            String leftText = input.substring(0, start);
            String rightText = input.substring(end);
            String newValue = leftText + keyChar + rightText;
            Matcher m = typing.matcher(newValue);
            if (m.find()) {
                String dateText = "";
                if (m.group(1) != null) {
                    dateText = dateText + m.group(1);
                }
                if (m.group(4) != null) {
                    dateText = dateText + "/";
                    dateText = dateText + m.group(4);
                }
                if (m.group(5) != null) {
                    dateText = dateText + "/";
                    dateText = dateText + m.group(5);
                }
                System.out.println(dateText);
                field.setText(dateText);
                if (end < input.length()) {
                    try {
                        String leading = Pattern.quote(leftText);
                        Pattern p = Pattern.compile(leading + ".*?(" + keyChar + ").*?");
                        Matcher caret = p.matcher(dateText);
                        if (caret.find()) {
                            field.setSelectionStart(caret.end(1));
                            field.setSelectionEnd(caret.end(1));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            event.setKeyChar('\u0000');
        } else if (keyChar != '/') {
            event.setKeyChar('\u0000');
        }
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 38) {
            this.datePicker.showPopup();
        } else if (event.getKeyCode() == 40) {
            this.datePicker.showPopup();
        } else if (event.getKeyCode() == 32) {
            event.setKeyCode(0);
            this.datePicker.showPopup();
        } else if (event.getKeyCode() == 27) {
            this.datePicker.hidePopup();
        }
    }

    public void keyReleased(KeyEvent event) {
    }
}

