/*
 * Decompiled with CFR 0.152.
 */
package feign.gson;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.gson.GsonFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;

public class GsonDecoder
implements Decoder {
    private final Gson gson;

    public GsonDecoder(Iterable<TypeAdapter<?>> adapters) {
        this(GsonFactory.create(adapters));
    }

    public GsonDecoder() {
        this(Collections.emptyList());
    }

    public GsonDecoder(Gson gson) {
        this.gson = gson;
    }

    public Object decode(Response response, Type type) throws IOException {
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader(Util.UTF_8);
        try {
            Object object = this.gson.fromJson(reader, type);
            return object;
        }
        catch (JsonIOException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw e;
        }
        finally {
            Util.ensureClosed((Closeable)reader);
        }
    }
}

