/*
 * Decompiled with CFR 0.152.
 */
package courgette.api.testng;

import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteLoader;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunOptions;
import courgette.runtime.CourgetteRunner;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteSession;
import courgette.runtime.CourgetteTestErrorException;
import courgette.runtime.CourgetteTestFailureException;
import courgette.runtime.CucumberPickleLocation;
import io.cucumber.core.gherkin.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class TestNGCourgette {
    private CourgetteProperties courgetteProperties;
    private List<CourgetteRunnerInfo> runnerInfoList;

    @BeforeClass(alwaysRun=true)
    public void initialize() {
        CourgetteRunOptions courgetteOptions = new CourgetteRunOptions(this.getClass());
        this.courgetteProperties = new CourgetteProperties(courgetteOptions, CourgetteSession.current().sessionId(), courgetteOptions.threads());
        CourgetteLoader courgetteFeatureLoader = new CourgetteLoader(this.courgetteProperties);
        List<Feature> features = courgetteFeatureLoader.getFeatures();
        this.runnerInfoList = new ArrayList<CourgetteRunnerInfo>();
        if (this.courgetteProperties.isFeatureRunLevel()) {
            features.forEach(feature -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)feature, null)));
        } else {
            Map<CucumberPickleLocation, Feature> scenarios = courgetteFeatureLoader.getCucumberScenarios();
            scenarios.keySet().forEach(location -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (Feature)scenarios.get(location), location.getLine())));
        }
    }

    @Test
    public void parallelRun() {
        CourgetteRunner courgetteRunner = new CourgetteRunner(this.runnerInfoList, this.courgetteProperties);
        try {
            if (courgetteRunner.canRunFeatures()) {
                switch (courgetteRunner.run()) {
                    case OK: {
                        courgetteRunner.createCucumberReport();
                        courgetteRunner.createCourgetteReport();
                        courgetteRunner.createCourgettePluginReports();
                        break;
                    }
                    case REPORT_PROCESSING_ERROR: {
                        CourgetteException.printError("[Courgette Runner] There was an unexpected error processing the individual Cucumber report files and Courgette was unable to create any reports for this test run.");
                        break;
                    }
                    case ERROR: {
                        CourgetteTestErrorException.throwTestErrorException();
                    }
                }
                if (!courgetteRunner.getFailures().isEmpty()) {
                    courgetteRunner.createRerunFile();
                    throw new CourgetteTestFailureException("There were failing tests.");
                }
            }
        }
        finally {
            courgetteRunner.printCourgetteTestStatistics();
            courgetteRunner.printCourgetteTestFailures();
            courgetteRunner.cleanupCourgetteHtmlReportFiles();
        }
    }
}

