/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.extentreports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.MediaEntityBuilder;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.Asterisk;
import com.aventstack.extentreports.gherkin.model.Feature;
import com.aventstack.extentreports.model.SystemEnvInfo;
import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import courgette.integration.extentreports.ExtentReportsProperties;
import courgette.runtime.CourgetteEnvironmentInfo;
import courgette.runtime.CourgetteException;
import courgette.runtime.report.model.Embedding;
import courgette.runtime.report.model.Hook;
import courgette.runtime.report.model.Result;
import courgette.runtime.report.model.Scenario;
import courgette.runtime.report.model.Step;
import courgette.runtime.report.model.Tag;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExtentReportsBuilder {
    private ExtentReportsProperties extentReportsProperties;
    private List<courgette.runtime.report.model.Feature> featureList;
    private Function<List<Result>, Long> calculateDuration = source -> source.stream().mapToLong(Result::getDuration).sum();

    private ExtentReportsBuilder(ExtentReportsProperties extentReportsProperties, List<courgette.runtime.report.model.Feature> featureList) {
        this.extentReportsProperties = extentReportsProperties;
        this.featureList = featureList;
    }

    public static ExtentReportsBuilder create(ExtentReportsProperties extentReportProperties, List<courgette.runtime.report.model.Feature> featureList) {
        return new ExtentReportsBuilder(extentReportProperties, featureList);
    }

    public void buildReport() {
        ExtentSparkReporter extentSparkReporter = this.createExtentSparkReporter();
        ExtentReports extentReports = new ExtentReports();
        extentReports.setReportUsesManualConfiguration(true);
        extentReports.attachReporter(new ExtentObserver[]{extentSparkReporter});
        this.addSystemEnvInfo(extentReports);
        List<String> featureUris = this.getDistinctFeatureUris();
        featureUris.forEach(featureUri -> {
            List<courgette.runtime.report.model.Feature> features = this.featureList.stream().filter(f -> f.getUri().equals(featureUri)).collect(Collectors.toList());
            this.addFeatures(extentReports, features);
        });
        if (!featureUris.isEmpty()) {
            extentReports.flush();
        }
    }

    private ExtentSparkReporter createExtentSparkReporter() {
        ExtentSparkReporter extentSparkReporter = new ExtentSparkReporter(this.extentReportsProperties.getReportFilename());
        if (this.extentReportsProperties.getXMLConfigFile() != null) {
            try {
                extentSparkReporter.loadXMLConfig(this.extentReportsProperties.getXMLConfigFile());
            }
            catch (IOException e) {
                CourgetteException.printError("[Courgette Extent Reports Plugin] Unable to load the Extent Reports XML config. Will use default settings. Reason: " + e.getMessage());
            }
        }
        return extentSparkReporter;
    }

    private List<String> getDistinctFeatureUris() {
        return this.featureList.stream().map(courgette.runtime.report.model.Feature::getUri).distinct().collect(Collectors.toList());
    }

    private void addFeatures(ExtentReports extentReports, List<courgette.runtime.report.model.Feature> features) {
        ExtentTest featureNode = this.createBddTest(extentReports, features.get(0).getName());
        features.forEach(feature -> {
            if (feature.getScenarios().size() > 1) {
                this.addFeatureStartAndEndTime(featureNode, (courgette.runtime.report.model.Feature)feature);
            }
            for (Scenario scenario : feature.getScenarios()) {
                if (!scenario.getKeyword().startsWith("Scenario")) continue;
                this.addScenario(featureNode, scenario);
                this.addScenarioStartAndEndTime(featureNode, scenario);
            }
        });
    }

    private ExtentTest createBddTest(ExtentReports extentReports, String featureName) {
        ExtentTest featureNode = extentReports.createTest(featureName);
        featureNode.getModel().setBddType(Feature.class);
        return featureNode;
    }

    private void addScenario(ExtentTest featureNode, Scenario scenario) {
        ExtentTest scenarioNode = this.createGherkinNode(featureNode, "Scenario", scenario.getName(), false);
        this.addBeforeOrAfterDetails(scenarioNode, scenario.getBefore());
        this.addSteps(scenarioNode, scenario);
        this.addBeforeOrAfterDetails(scenarioNode, scenario.getAfter());
        this.assignCategoryToScenario(scenarioNode, scenario.getTags());
    }

    private void assignCategoryToScenario(ExtentTest scenarioNode, List<Tag> tags) {
        tags.forEach(tag -> scenarioNode.assignCategory(new String[]{tag.getName()}));
    }

    private void addSteps(ExtentTest scenarioNode, Scenario scenario) {
        Date startTime = this.getStartTime(scenario.getStartTimestamp());
        List<Step> steps = scenario.getSteps();
        steps.forEach(step -> {
            this.addBeforeOrAfterDetails(scenarioNode, step.getBefore());
            ExtentTest stepNode = this.createStepNode(scenarioNode, (Step)step, startTime);
            this.addAdditionalStepDetails(stepNode, (Step)step);
            this.setStepResult(stepNode, (Step)step);
            this.addBeforeOrAfterDetails(scenarioNode, step.getAfter());
        });
    }

    private ExtentTest createStepNode(ExtentTest scenarioNode, Step step, Date startTime) {
        ExtentTest stepNode = this.createGherkinNode(scenarioNode, step.getKeyword().trim(), step.getName(), true);
        stepNode.getModel().setStartTime(startTime);
        return stepNode;
    }

    private void addBeforeOrAfterDetails(ExtentTest scenarioNode, List<Hook> hooks) {
        hooks.forEach(hook -> {
            String error = hook.getResult().getErrorMessage();
            List<String> output = hook.getOutput();
            List<Embedding> embeddings = hook.getEmbeddings();
            ExtentTest hookNode = scenarioNode.createNode(Asterisk.class, hook.getLocation());
            this.addOutputs(hookNode, output);
            this.addError(hookNode, error);
            this.addImageEmbeddings(hookNode, embeddings);
        });
    }

    private void addAdditionalStepDetails(ExtentTest stepNode, Step step) {
        String error = step.getResult().getErrorMessage();
        List<String> output = step.getOutput();
        List<Embedding> embeddings = step.getEmbeddings();
        this.addOutputs(stepNode, output);
        this.addError(stepNode, error);
        this.addImageEmbeddings(stepNode, embeddings);
    }

    private void addOutputs(ExtentTest node, List<String> outputs) {
        outputs.forEach(output -> this.log(node, (String)output));
    }

    private void addImageEmbeddings(ExtentTest node, List<Embedding> embeddings) {
        embeddings.forEach(embedding -> {
            if (embedding.getMimeType().startsWith("image")) {
                this.addBase64ScreenCapture(node, embedding.getData());
            }
        });
    }

    private void addBase64ScreenCapture(ExtentTest node, String base64Image) {
        node.log(Status.INFO, "", MediaEntityBuilder.createScreenCaptureFromBase64String((String)base64Image).build());
    }

    private void addError(ExtentTest node, String error) {
        this.log(node, error);
    }

    private void log(ExtentTest node, String message) {
        if (message != null) {
            node.log(Status.INFO, message);
        }
    }

    private ExtentTest createGherkinNode(ExtentTest parent, String keyword, String name, boolean appendKeyword) {
        try {
            String nodeName = appendKeyword ? keyword + " " + name : name;
            return parent.createNode(new GherkinKeyword(keyword), nodeName);
        }
        catch (ClassNotFoundException e) {
            throw new CourgetteException(e);
        }
    }

    private void setStepResult(ExtentTest extentTest, Step step) {
        if (step.skipped()) {
            extentTest.skip("");
        } else if (step.passed()) {
            extentTest.pass("");
        } else {
            extentTest.fail("");
        }
    }

    private void addFeatureStartAndEndTime(ExtentTest featureNode, courgette.runtime.report.model.Feature feature) {
        Date featureStartTime = this.getEarliestStartTime(feature.getScenarios());
        Date featureEndTime = this.getEndTime(featureStartTime.getTime(), feature.getScenarios());
        this.addStartAndEndTime(featureNode, featureStartTime, featureEndTime);
    }

    private void addScenarioStartAndEndTime(ExtentTest scenarioNode, Scenario scenario) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        scenarios.add(scenario);
        Date scenarioStartTime = this.getStartTime(scenario.getStartTimestamp());
        Date scenarioEndTime = this.getEndTime(scenarioStartTime.getTime(), scenarios);
        this.addStartAndEndTime(scenarioNode, scenarioStartTime, scenarioEndTime);
    }

    private void addStartAndEndTime(ExtentTest node, Date startTime, Date endTime) {
        node.getModel().setStartTime(startTime);
        node.getModel().setEndTime(endTime);
    }

    private Date getEarliestStartTime(List<Scenario> scenarios) {
        ArrayList times = new ArrayList();
        scenarios.stream().map(Scenario::getStartTimestamp).filter(time -> time.length() > 0).forEach(time -> times.add(Date.from(Instant.parse(time)).getTime()));
        return new Date((Long)times.stream().reduce((start, end) -> start).get());
    }

    private Date getStartTime(String timestamp) {
        return Date.from(Instant.parse(timestamp));
    }

    private Date getEndTime(long startTime, List<Scenario> scenarios) {
        long endTime = 0L;
        for (Scenario scenario : scenarios) {
            endTime += this.calculateDuration.apply(scenario.getBefore().stream().map(Hook::getResult).collect(Collectors.toList())).longValue();
            endTime += this.calculateDuration.apply(scenario.getAfter().stream().map(Hook::getResult).collect(Collectors.toList())).longValue();
            endTime += this.calculateDuration.apply(scenario.getSteps().stream().map(Step::getResult).collect(Collectors.toList())).longValue();
            endTime += this.calculateDuration.apply(scenario.getSteps().stream().flatMap(s -> s.getBefore().stream()).map(Hook::getResult).collect(Collectors.toList())).longValue();
            endTime += this.calculateDuration.apply(scenario.getSteps().stream().flatMap(s -> s.getAfter().stream()).map(Hook::getResult).collect(Collectors.toList())).longValue();
        }
        return new Date(startTime + endTime);
    }

    private void addSystemEnvInfo(ExtentReports report) {
        ArrayList systemEnvInfo = new ArrayList();
        new CourgetteEnvironmentInfo(this.extentReportsProperties.getEnvironmentInfo()).defaultEnvironment().forEach((key, value) -> systemEnvInfo.add(new SystemEnvInfo(key, value)));
        report.getReport().getSystemEnvInfo().addAll(systemEnvInfo);
    }
}

