/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.reportportal.request;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import courgette.runtime.report.model.Embedding;
import courgette.runtime.report.model.Hook;
import courgette.runtime.report.model.Result;
import courgette.runtime.report.model.Scenario;
import courgette.runtime.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class ScenarioLogRequest {
    public HttpEntity create(Scenario scenario, String scenarioId, String launchId) {
        ArrayList<File> fileAttachments = new ArrayList<File>();
        Instant startTime = Instant.parse(scenario.getStartTimestamp());
        JsonArray logArray = new JsonArray();
        ScenarioLogRequest.addHooks(logArray, scenario.getBefore(), launchId, scenarioId, startTime, -1000, fileAttachments);
        ScenarioLogRequest.addSteps(logArray, scenario, launchId, scenarioId, startTime, fileAttachments);
        ScenarioLogRequest.addHooks(logArray, scenario.getAfter(), launchId, scenarioId, startTime, 1000, fileAttachments);
        MultipartEntityBuilder mb = MultipartEntityBuilder.create().addPart("json_request_part", (ContentBody)new StringBody(logArray.toString(), ContentType.APPLICATION_JSON));
        fileAttachments.forEach(f -> mb.addPart("file", (ContentBody)new FileBody(f, ContentType.IMAGE_PNG)));
        return mb.build();
    }

    private static void addSteps(JsonArray logArray, Scenario scenario, String launchId, String scenarioId, Instant startTime, List<File> fileAttachments) {
        scenario.getSteps().forEach(step -> {
            Instant stepTime = startTime.minusMillis(step.getResult().getDuration());
            JsonObject logBody = new JsonObject();
            ScenarioLogRequest.addHooks(logArray, step.getBefore(), launchId, scenarioId, stepTime, 0, fileAttachments);
            logBody.addProperty("launchUuid", launchId);
            logBody.addProperty("itemUuid", scenarioId);
            logBody.addProperty("time", String.valueOf(stepTime));
            logBody.addProperty("message", step.getKeyword() + step.getName() + ScenarioLogRequest.toStatusName(step.getResult()));
            logBody.addProperty("level", ScenarioLogRequest.toLevel(step.getResult()));
            ScenarioLogRequest.addImageAttachment(logBody, step.getEmbeddings(), fileAttachments);
            ScenarioLogRequest.addHooks(logArray, step.getAfter(), launchId, scenarioId, stepTime, 200, fileAttachments);
            logArray.add((JsonElement)logBody);
        });
    }

    private static void addHooks(JsonArray logArray, List<Hook> hooks, String launchId, String scenarioId, Instant startTime, int timeOffset, List<File> fileAttachments) {
        hooks.forEach(hook -> {
            JsonObject logBody = new JsonObject();
            logBody.addProperty("launchUuid", launchId);
            logBody.addProperty("itemUuid", scenarioId);
            logBody.addProperty("time", String.valueOf(startTime.minusMillis(hook.getResult().getDuration() - (long)timeOffset)));
            logBody.addProperty("message", hook.getLocation() + ScenarioLogRequest.toStatusName(hook.getResult()));
            logBody.addProperty("level", ScenarioLogRequest.toLevel(hook.getResult()));
            ScenarioLogRequest.addImageAttachment(logBody, hook.getEmbeddings(), fileAttachments);
            logArray.add((JsonElement)logBody);
        });
    }

    private static void addImageAttachment(JsonObject logBody, List<Embedding> embeddings, List<File> fileAttachments) {
        Optional<Embedding> image = embeddings.stream().filter(e -> e.getMimeType().contains("image")).findFirst();
        if (image.isPresent()) {
            byte[] decodedBytes = Base64.getDecoder().decode(image.get().getData());
            try {
                File imageAttachment = FileUtils.getTempFile("png");
                fileAttachments.add(imageAttachment);
                FileOutputStream fos = new FileOutputStream(imageAttachment);
                fos.write(decodedBytes);
                fos.close();
                JsonObject fileBody = new JsonObject();
                fileBody.addProperty("name", imageAttachment.getName());
                fileBody.addProperty("contentType", "image");
                logBody.add("file", (JsonElement)fileBody);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    private static String toLevel(Result result) {
        String status = result.getStatus();
        if (status.equalsIgnoreCase("skipped")) {
            return "warn";
        }
        if (status.equalsIgnoreCase("passed")) {
            return "info";
        }
        return "error";
    }

    private static String toStatusName(Result result) {
        return String.format(" (%s)", result.getStatus());
    }
}

