/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CourgetteEnvironmentInfo {
    private final String environmentInfo;

    public CourgetteEnvironmentInfo(String environmentInfo) {
        this.environmentInfo = environmentInfo;
    }

    public List<String> list() {
        String[] values;
        ArrayList<String> environment = new ArrayList<String>();
        for (String value : values = this.environmentInfo.trim().split(";")) {
            String[] keyValue = value.trim().split("=");
            if (keyValue.length != 2) continue;
            environment.add(keyValue[0].trim() + " = " + keyValue[1].trim());
        }
        return environment;
    }

    public Map<String, String> map() {
        HashMap<String, String> environment = new HashMap<String, String>();
        this.list().forEach(info -> {
            String[] keyPair = info.split("=");
            environment.put(keyPair[0].trim(), keyPair[1].trim());
        });
        return environment;
    }

    public LinkedHashMap<String, String> defaultEnvironment() {
        LinkedHashMap<String, String> environment = this.createDefaultEnvironment();
        environment.putAll(this.map());
        return environment;
    }

    private LinkedHashMap<String, String> createDefaultEnvironment() {
        LinkedHashMap<String, String> defaultEnvironment = new LinkedHashMap<String, String>();
        defaultEnvironment.put("os_name", System.getProperty("os.name"));
        defaultEnvironment.put("os_arch", System.getProperty("os.arch"));
        defaultEnvironment.put("java_version", System.getProperty("java.version"));
        return defaultEnvironment;
    }
}

