/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteException;
import courgette.runtime.utils.JacksonUtils;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.messages.NdjsonToMessageIterable;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CourgetteNdJsonCreator {
    private final Map<Feature, List<List<Envelope>>> messages;
    private final Predicate<Envelope> gherkinEnvelope = envelope -> envelope.getGherkinDocument().isPresent();
    private final Predicate<Envelope> metaEnvelope = envelope -> envelope.getMeta().isPresent();
    private final Predicate<Envelope> testRunStartedOrFinishedEnvelope = envelope -> envelope.getTestRunStarted().isPresent() || envelope.getTestRunFinished().isPresent();
    private final Predicate<Optional<TestCase>> testCase = testCase -> testCase.isPresent() && !((TestCase)testCase.get()).getPickleId().equals("");

    public CourgetteNdJsonCreator(Map<Feature, List<List<Envelope>>> messages) {
        this.messages = messages;
    }

    public static List<Envelope> createMessages(String source) {
        List<String> messageList = Arrays.asList(source.split("\n"));
        ArrayList<Envelope> messages = new ArrayList<Envelope>(messageList.size());
        messageList.forEach(message -> {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
                for (Envelope envelope : new NdjsonToMessageIterable((InputStream)in, (NdjsonToMessageIterable.Deserializer)new NdJsonMessageDeserializer())) {
                    messages.add(envelope);
                }
            }
            catch (Exception e) {
                CourgetteException.printExceptionStackTrace(e);
            }
        });
        return messages;
    }

    public List<Envelope> createFeatureMessages() {
        return this.getMessages();
    }

    public List<Envelope> createScenarioMessages() {
        return this.getScenarioMessages();
    }

    private List<Envelope> getMessages() {
        List<Envelope> featureMessages = this.messages.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toList());
        return this.mutateMessages(featureMessages);
    }

    private List<Envelope> getScenarioMessages() {
        ArrayList<Envelope> scenarioMessages = new ArrayList<Envelope>();
        this.messages.forEach((k, v) -> {
            ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
            ArrayList<Envelope> messages = new ArrayList<Envelope>();
            v.forEach(message -> this.addMessage((List<Envelope>)message, (List<Scenario>)scenarios, (List<Envelope>)messages));
            Envelope oldGherkinDocument = this.extractFirstGherkinDocument(messages);
            Envelope newGherkinDocument = this.createNewGherkinDocument(oldGherkinDocument, scenarios);
            messages.removeIf(this.gherkinEnvelope);
            messages.add(3, newGherkinDocument);
            scenarioMessages.addAll(messages);
        });
        return this.mutateMessages(scenarioMessages);
    }

    private List<Envelope> mutateMessages(List<Envelope> envelopes) {
        if (envelopes != null && !envelopes.isEmpty()) {
            Envelope testRunStarted = this.createTestRunStarted(envelopes);
            Envelope testRunFinished = this.createTestRunFinished(envelopes);
            envelopes.subList(1, envelopes.size()).removeIf(this.metaEnvelope);
            envelopes.removeIf(this.testRunStartedOrFinishedEnvelope);
            envelopes.add(2, testRunStarted);
            envelopes.add(testRunFinished);
            return envelopes;
        }
        return null;
    }

    private void addMessage(List<Envelope> envelopes, List<Scenario> scenarios, List<Envelope> messages) {
        ArrayList envelopeList = new ArrayList();
        Optional<TestCase> testCase = this.extractTestCase(envelopes);
        Optional<Pickle> pickle = this.extractPickle(envelopes, testCase);
        envelopes.forEach(envelope -> {
            if (pickle.isPresent()) {
                if (envelope.getGherkinDocument().isPresent() && ((GherkinDocument)envelope.getGherkinDocument().get()).getFeature().isPresent()) {
                    Optional<Scenario> scenario = ((io.cucumber.messages.types.Feature)((GherkinDocument)envelope.getGherkinDocument().get()).getFeature().get()).getChildren().stream().map(FeatureChild::getScenario).filter(Objects::nonNull).filter(s -> s.isPresent() && ((Scenario)s.get()).getId().equals(((Pickle)pickle.get()).getAstNodeIds().get(0))).findFirst().orElse(Optional.empty());
                    scenario.ifPresent(scenarios::add);
                    envelopeList.add(envelope);
                } else if (envelope.getPickle().isPresent()) {
                    if (envelope.getPickle().get() == pickle.get()) {
                        envelopeList.add(envelope);
                    }
                } else {
                    envelopeList.add(envelope);
                }
            }
        });
        messages.addAll(envelopeList);
    }

    private Envelope extractFirstGherkinDocument(List<Envelope> envelopes) {
        return envelopes.stream().filter(this.gherkinEnvelope).findFirst().get();
    }

    private Envelope createNewGherkinDocument(Envelope envelope, List<Scenario> scenarios) {
        ArrayList children = new ArrayList();
        scenarios.forEach(scenario -> children.add(FeatureChild.of((Scenario)scenario)));
        io.cucumber.messages.types.Feature currentFeature = (io.cucumber.messages.types.Feature)envelope.getGherkinDocument().flatMap(GherkinDocument::getFeature).get();
        io.cucumber.messages.types.Feature newFeature = new io.cucumber.messages.types.Feature(currentFeature.getLocation(), currentFeature.getTags(), currentFeature.getLanguage(), currentFeature.getKeyword(), currentFeature.getName(), currentFeature.getDescription(), children);
        GherkinDocument currentGherkinDoc = (GherkinDocument)envelope.getGherkinDocument().get();
        GherkinDocument newGherkinDoc = new GherkinDocument((String)currentGherkinDoc.getUri().get(), newFeature, currentGherkinDoc.getComments());
        return Envelope.of((GherkinDocument)newGherkinDoc);
    }

    private Optional<TestCase> extractTestCase(List<Envelope> envelopes) {
        return envelopes.stream().map(Envelope::getTestCase).filter(Objects::nonNull).filter(this.testCase).findFirst().get();
    }

    private Optional<Pickle> extractPickle(List<Envelope> envelopes, Optional<TestCase> testCase) {
        if (!envelopes.isEmpty() && testCase.isPresent()) {
            return envelopes.stream().map(Envelope::getPickle).filter(Objects::nonNull).filter(pickle -> pickle.isPresent() && ((Pickle)pickle.get()).getId().equals(((TestCase)testCase.get()).getPickleId())).findFirst().orElse(Optional.empty());
        }
        return Optional.empty();
    }

    private Envelope createTestRunStarted(List<Envelope> envelopes) {
        Timestamp timestamp = envelopes.stream().filter(envelope -> envelope.getTestRunStarted().isPresent()).map(envelope -> ((TestRunStarted)envelope.getTestRunStarted().get()).getTimestamp()).min(Comparator.comparingLong(Timestamp::getSeconds)).get();
        return Envelope.of((TestRunStarted)new TestRunStarted(timestamp));
    }

    private Envelope createTestRunFinished(List<Envelope> envelopes) {
        Timestamp timestamp = envelopes.stream().filter(envelope -> envelope.getTestRunFinished().isPresent()).map(envelope -> ((TestRunFinished)envelope.getTestRunFinished().get()).getTimestamp()).min(Comparator.comparingLong(Timestamp::getSeconds)).get();
        return Envelope.of((TestRunFinished)new TestRunFinished(null, Boolean.valueOf(true), timestamp, null));
    }

    private static class NdJsonMessageDeserializer
    implements NdjsonToMessageIterable.Deserializer {
        private NdJsonMessageDeserializer() {
        }

        public Envelope readValue(String json) throws IOException {
            return (Envelope)JacksonUtils.CUCUMBER_OBJECT_MAPPER.readValue(json, Envelope.class);
        }
    }
}

