/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRuntimeOptions;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CourgetteRunnerInfo {
    private final CourgetteRuntimeOptions courgetteRuntimeOptions;
    private final Integer lineId;
    private final CourgetteRunLevel courgetteRunLevel;
    private final Feature feature;
    private final boolean rerun;

    public CourgetteRunnerInfo(CourgetteProperties courgetteProperties, Feature feature, Integer lineId) {
        this.feature = feature;
        this.courgetteRuntimeOptions = new CourgetteRuntimeOptions(courgetteProperties, feature);
        this.lineId = lineId;
        this.courgetteRunLevel = courgetteProperties.getCourgetteOptions().runLevel();
        this.rerun = courgetteProperties.getCourgetteOptions().rerunFailedScenarios() && this.checkRerunCondition(feature, courgetteProperties.getCourgetteOptions().excludeFeatureFromRerun(), courgetteProperties.getCourgetteOptions().excludeTagFromRerun());
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Integer getLineId() {
        return this.lineId;
    }

    public Map<String, List<String>> getRuntimeOptions() {
        Map<String, List<String>> runtimeOptions = this.courgetteRuntimeOptions.mapRuntimeOptions();
        if (this.courgetteRunLevel.equals((Object)CourgetteRunLevel.SCENARIO) && this.lineId != null) {
            String featurePath = runtimeOptions.get(null).get(0);
            ArrayList<String> scenarioPath = new ArrayList<String>();
            scenarioPath.add(String.format("%s:%s", featurePath, this.lineId));
            runtimeOptions.put(null, scenarioPath);
            runtimeOptions.remove("--tags");
        }
        return runtimeOptions;
    }

    public Map<String, List<String>> getRerunRuntimeOptions(String rerun) {
        Map<String, List<String>> rerunRuntimeOptions = this.getRuntimeOptions();
        rerunRuntimeOptions.remove("--tags");
        ArrayList<String> scenarioPath = new ArrayList<String>();
        scenarioPath.add(rerun);
        rerunRuntimeOptions.put(null, scenarioPath);
        return rerunRuntimeOptions;
    }

    public String getRerunFile() {
        return this.courgetteRuntimeOptions.getRerunFile();
    }

    public List<String> getReportFiles() {
        return this.courgetteRuntimeOptions.getReportFiles();
    }

    public File getJsonReportFile() {
        String jsonReport = this.courgetteRuntimeOptions.getJsonReportFile();
        if (jsonReport != null) {
            return new File(jsonReport);
        }
        return null;
    }

    public boolean allowRerun() {
        return this.rerun;
    }

    private boolean checkRerunCondition(Feature feature, String[] excludedRerunFeatures, String[] excludedRerunTags) {
        return Arrays.stream(excludedRerunFeatures).map(String::trim).map(String::toLowerCase).noneMatch(featureName -> feature.getUri().getPath().toLowerCase().contains((CharSequence)featureName)) && Arrays.stream(excludedRerunTags).map(String::trim).map(String::toLowerCase).noneMatch(featureTag -> feature.getPickles().stream().map(Pickle::getTags).flatMap(Collection::stream).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet()).contains(featureTag));
    }
}

