/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

class CucumberReportPublisher {
    private final String CUCUMBER_PUBLISH_URL = System.getProperty("cucumber.publish.url", "https://messages.cucumber.io/api/reports");
    private final String CUCUMBER_REPORT_URL = "https://reports.cucumber.io/reports";
    private final String CUCUMBER_PUBLISH_TOKEN = "CUCUMBER_PUBLISH_TOKEN";
    private File messageFile;
    private HttpClient httpClient;
    private List<String> errors = new ArrayList<String>();

    public CucumberReportPublisher(File messageFile) {
        if (messageFile.exists()) {
            this.messageFile = messageFile;
            this.httpClient = this.createHttpClient();
        } else {
            this.errors.add("There are no Cucumber messages to publish.");
        }
    }

    public Optional<String> publish() {
        String report;
        String reportUrl = null;
        String token = System.getProperty("CUCUMBER_PUBLISH_TOKEN", System.getenv("CUCUMBER_PUBLISH_TOKEN"));
        if (this.httpClient != null && this.errors.isEmpty() && (report = this.createReport(token)) != null) {
            reportUrl = this.publishReport(report);
        }
        if (reportUrl == null && !this.errors.isEmpty()) {
            System.err.println("Courgette was unable to publish the Cucumber Report. Reason(s): " + this.createErrorString());
        }
        return Optional.ofNullable(reportUrl);
    }

    private String createReport(String token) {
        try {
            HttpResponse response;
            HttpGet resource = new HttpGet(this.CUCUMBER_PUBLISH_URL);
            if (token != null && !token.isEmpty()) {
                resource.addHeader("Authorization", "Bearer " + token);
            }
            if ((response = this.httpClient.execute((HttpUriRequest)resource)) != null) {
                if (response.getStatusLine().getStatusCode() == 202) {
                    Header location = response.getFirstHeader("Location");
                    if (location != null && !location.getValue().isEmpty()) {
                        return location.getValue();
                    }
                } else {
                    this.errors.add(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
                }
            } else {
                this.errors.add("No response received from server.");
            }
        }
        catch (IOException e) {
            this.errors.add(e.getMessage());
        }
        return null;
    }

    private String publishReport(String resourceUrl) {
        HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setFile(this.messageFile).build();
        try {
            HttpPut reportMessage = new HttpPut(resourceUrl);
            reportMessage.setEntity(entity);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)reportMessage);
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 200) {
                    String reportPath = URI.create(resourceUrl).getPath();
                    reportPath = reportPath.substring(reportPath.lastIndexOf("/"));
                    return "https://reports.cucumber.io/reports" + reportPath;
                }
                this.errors.add(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            } else {
                this.errors.add("No response received from server.");
            }
        }
        catch (Exception e) {
            this.errors.add(e.getMessage());
        }
        return null;
    }

    private HttpClient createHttpClient() {
        try {
            SSLContext trustedSSLContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
            return HttpClientBuilder.create().setSSLContext(trustedSSLContext).build();
        }
        catch (Exception e) {
            this.errors.add(e.getMessage());
            return null;
        }
    }

    private String createErrorString() {
        StringBuilder errorBuilder = new StringBuilder();
        this.errors.forEach(e -> errorBuilder.append("\n").append((String)e));
        return errorBuilder.toString();
    }
}

