/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.Snapshot;
import io.github.resilience4j.core.metrics.TotalAggregation;
import java.time.Duration;

public class SnapshotImpl
implements Snapshot {
    private final long totalDurationInMillis;
    private final int totalNumberOfSlowCalls;
    private final int totalNumberOfFailedCalls;
    private final int totalNumberOfCalls;

    SnapshotImpl(TotalAggregation totalAggregation) {
        this.totalDurationInMillis = totalAggregation.totalDurationInMillis;
        this.totalNumberOfSlowCalls = totalAggregation.numberOfSlowCalls;
        this.totalNumberOfFailedCalls = totalAggregation.numberOfFailedCalls;
        this.totalNumberOfCalls = totalAggregation.numberOfCalls;
    }

    @Override
    public Duration getTotalDuration() {
        return Duration.ofMillis(this.totalDurationInMillis);
    }

    @Override
    public int getNumberOfSlowCalls() {
        return this.totalNumberOfSlowCalls;
    }

    @Override
    public float getSlowCallRate() {
        if (this.totalNumberOfCalls == 0) {
            return 0.0f;
        }
        return (float)this.totalNumberOfSlowCalls * 100.0f / (float)this.totalNumberOfCalls;
    }

    @Override
    public int getNumberOfSuccessfulCalls() {
        return this.totalNumberOfCalls - this.totalNumberOfFailedCalls;
    }

    @Override
    public int getNumberOfFailedCalls() {
        return this.totalNumberOfFailedCalls;
    }

    @Override
    public int getTotalNumberOfCalls() {
        return this.totalNumberOfCalls;
    }

    @Override
    public float getFailureRate() {
        if (this.totalNumberOfCalls == 0) {
            return 0.0f;
        }
        return (float)this.totalNumberOfFailedCalls * 100.0f / (float)this.totalNumberOfCalls;
    }

    @Override
    public Duration getAverageDuration() {
        if (this.totalNumberOfCalls == 0) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(this.totalDurationInMillis / (long)this.totalNumberOfCalls);
    }
}

