/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics.publisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.metrics.publisher.AbstractMetricsPublisher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class ThreadPoolBulkheadMetricsPublisher
extends AbstractMetricsPublisher<ThreadPoolBulkhead> {
    private final String prefix;

    public ThreadPoolBulkheadMetricsPublisher() {
        this("resilience4j.thread_pool_bulkhead", new MetricRegistry());
    }

    public ThreadPoolBulkheadMetricsPublisher(MetricRegistry metricRegistry) {
        this("resilience4j.thread_pool_bulkhead", metricRegistry);
    }

    public ThreadPoolBulkheadMetricsPublisher(String prefix, MetricRegistry metricRegistry) {
        super(metricRegistry);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public void publishMetrics(ThreadPoolBulkhead threadPoolBulkhead) {
        String name = threadPoolBulkhead.getName();
        String currentThreadPoolSize = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "current_thread_pool_size"});
        String availableQueueCapacity = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "available_queue_capacity"});
        this.metricRegistry.register(currentThreadPoolSize, (Metric)((Gauge)() -> threadPoolBulkhead.getMetrics().getThreadPoolSize()));
        this.metricRegistry.register(availableQueueCapacity, (Metric)((Gauge)() -> threadPoolBulkhead.getMetrics().getRemainingQueueCapacity()));
        List<String> metricNames = Arrays.asList(currentThreadPoolSize, availableQueueCapacity);
        this.metricsNameMap.put(name, new HashSet<String>(metricNames));
    }

    public void removeMetrics(ThreadPoolBulkhead threadPoolBulkhead) {
        this.removeMetrics(threadPoolBulkhead.getName());
    }
}

