/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.retry.Retry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.Objects;

abstract class AbstractRetryMetrics
extends AbstractMetrics {
    protected final MetricNames names;

    protected AbstractRetryMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, Retry retry) {
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt()).description("The number of successful calls without a retry attempt").tag("name", retry.getName()).tag("kind", "successful_without_retry").register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt()).description("The number of successful calls after a retry attempt").tag("name", retry.getName()).tag("kind", "successful_with_retry").register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt()).description("The number of failed calls without a retry attempt").tag("name", retry.getName()).tag("kind", "failed_without_retry").register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithRetryAttempt()).description("The number of failed calls after a retry attempt").tag("name", retry.getName()).tag("kind", "failed_with_retry").register(meterRegistry).getId());
        this.meterIdMap.put(retry.getName(), idSet);
    }

    public static class MetricNames {
        public static final String DEFAULT_RETRY_CALLS = "resilience4j.retry.calls";
        private String callsMetricName = "resilience4j.retry.calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        private MetricNames() {
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

