/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer;

import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.core.functions.CheckedRunnable;
import io.github.resilience4j.core.functions.CheckedSupplier;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Observations {
    private Observations() {
        throw new IllegalStateException("Should not instantiate a utility class");
    }

    static Observation ofObservationRegistry(String name, ObservationRegistry observationRegistry) {
        return Observation.createNotStarted((String)name, (ObservationRegistry)observationRegistry);
    }

    static Observation ofObservationRegistry(String name, Supplier<Observation.Context> context, ObservationRegistry observationRegistry) {
        return Observation.createNotStarted((String)name, context, (ObservationRegistry)observationRegistry);
    }

    static <T> CheckedSupplier<T> decorateCheckedSupplier(Observation observation, CheckedSupplier<T> supplier) {
        return () -> observation.observeChecked(() -> ((CheckedSupplier)supplier).get());
    }

    static CheckedRunnable decorateCheckedRunnable(Observation observation, CheckedRunnable runnable) {
        return () -> observation.observeChecked(() -> ((CheckedRunnable)runnable).run());
    }

    static <T> Supplier<T> decorateSupplier(Observation observation, Supplier<T> supplier) {
        return () -> observation.observe(supplier);
    }

    static <T> Callable<T> decorateCallable(Observation observation, Callable<T> callable) {
        return () -> {
            observation.start();
            try {
                Object v = callable.call();
                return v;
            }
            catch (Exception e) {
                observation.error((Throwable)e);
                throw e;
            }
            finally {
                observation.stop();
            }
        };
    }

    static Runnable decorateRunnable(Observation observation, Runnable runnable) {
        return () -> observation.observe(runnable);
    }

    static <T, R> Function<T, R> decorateFunction(Observation observation, Function<T, R> function) {
        return t -> observation.observe(() -> function.apply(t));
    }

    static <T, R> CheckedFunction<T, R> decorateCheckedFunction(Observation observation, CheckedFunction<T, R> function) {
        return t -> observation.observeChecked(() -> function.apply(t));
    }

    static <T> Supplier<CompletionStage<T>> decorateCompletionStageSupplier(Observation observation, Supplier<CompletionStage<T>> stageSupplier) {
        return () -> {
            observation.start();
            try {
                CompletionStage stage = (CompletionStage)stageSupplier.get();
                stage.whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        observation.error(throwable);
                    }
                    observation.stop();
                });
                return stage;
            }
            catch (Throwable throwable2) {
                observation.error(throwable2).stop();
                throw throwable2;
            }
        };
    }

    static void executeRunnable(Observation observation, Runnable runnable) {
        Observations.decorateRunnable(observation, runnable).run();
    }

    static <T> T executeCallable(Observation observation, Callable<T> callable) throws Exception {
        return Observations.decorateCallable(observation, callable).call();
    }

    static <T> T executeSupplier(Observation observation, Supplier<T> supplier) {
        return Observations.decorateSupplier(observation, supplier).get();
    }

    static <T> CompletionStage<T> executeCompletionStageSupplier(Observation observation, Supplier<CompletionStage<T>> supplier) {
        return Observations.decorateCompletionStageSupplier(observation, supplier).get();
    }
}

