/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus;

import io.github.resilience4j.prometheus.CallMeter;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public interface CallMeterBase {
    public Timer startTimer();

    default public void executeRunnable(Runnable runnable) throws Exception {
        CallMeter.decorateRunnable(this, runnable).run();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return CallMeter.decorateCallable(this, callable).call();
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return CallMeter.decorateSupplier(this, supplier).get();
    }

    default public <T> CompletionStage<T> executeCompletionStageSupplier(Supplier<CompletionStage<T>> supplier) {
        return CallMeter.decorateCompletionStageSupplier(this, supplier).get();
    }

    public static interface Timer {
        public void onError();

        public void onSuccess();
    }
}

