/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus.collectors;

import io.github.resilience4j.prometheus.LabelNames;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RetryMetricsCollector
extends Collector {
    private final MetricNames names;
    private final RetryRegistry retryRegistry;

    private RetryMetricsCollector(MetricNames names, RetryRegistry retryRegistry) {
        this.names = Objects.requireNonNull(names);
        this.retryRegistry = Objects.requireNonNull(retryRegistry);
    }

    public static RetryMetricsCollector ofRetryRegistry(MetricNames names, RetryRegistry retryRegistry) {
        return new RetryMetricsCollector(names, retryRegistry);
    }

    public static RetryMetricsCollector ofRetryRegistry(RetryRegistry retryRegistry) {
        return new RetryMetricsCollector(MetricNames.ofDefaults(), retryRegistry);
    }

    public List<Collector.MetricFamilySamples> collect() {
        GaugeMetricFamily retryCallsFamily = new GaugeMetricFamily(this.names.getCallsMetricName(), "The number of calls", LabelNames.NAME_AND_KIND);
        for (Retry retry : this.retryRegistry.getAllRetries()) {
            retryCallsFamily.addMetric(Arrays.asList(retry.getName(), "successful_without_retry"), (double)retry.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt());
            retryCallsFamily.addMetric(Arrays.asList(retry.getName(), "successful_with_retry"), (double)retry.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt());
            retryCallsFamily.addMetric(Arrays.asList(retry.getName(), "failed_without_retry"), (double)retry.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt());
            retryCallsFamily.addMetric(Arrays.asList(retry.getName(), "failed_with_retry"), (double)retry.getMetrics().getNumberOfFailedCallsWithRetryAttempt());
        }
        return Collections.singletonList(retryCallsFamily);
    }

    public static class MetricNames {
        public static final String DEFAULT_RETRY_CALLS = "resilience4j_retry_calls";
        private String callsMetricName = "resilience4j_retry_calls";

        private MetricNames() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

