/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.monitoring.endpoint;

import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.common.bulkhead.monitoring.endpoint.BulkheadEventDTOFactory;
import io.github.resilience4j.common.bulkhead.monitoring.endpoint.BulkheadEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.vavr.collection.List;
import java.util.Comparator;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bulkhead/"})
public class BulkheadEventsEndpoint {
    private final EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry;

    public BulkheadEventsEndpoint(EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @GetMapping(value={"events"}, produces={"application/json"})
    @ResponseBody
    public BulkheadEventsEndpointResponse getAllBulkheadEvents() {
        java.util.List response = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(BulkheadEvent::getCreationTime)).map(BulkheadEventDTOFactory::createBulkheadEventDTO).toJavaList();
        return new BulkheadEventsEndpointResponse(response);
    }

    @GetMapping(value={"events/{bulkheadName}"}, produces={"application/json"})
    @ResponseBody
    public BulkheadEventsEndpointResponse getEventsFilteredByBulkheadName(@PathVariable(value="bulkheadName") String bulkheadName) {
        java.util.List response = this.getBulkheadEvent(bulkheadName).map(BulkheadEventDTOFactory::createBulkheadEventDTO).toJavaList();
        return new BulkheadEventsEndpointResponse(response);
    }

    @GetMapping(value={"events/{bulkheadName}/{eventType}"}, produces={"application/json"})
    @ResponseBody
    public BulkheadEventsEndpointResponse getEventsFilteredByBulkheadNameAndEventType(@PathVariable(value="bulkheadName") String bulkheadName, @PathVariable(value="eventType") String eventType) {
        java.util.List response = this.getBulkheadEvent(bulkheadName).filter(event -> event.getEventType() == BulkheadEvent.Type.valueOf((String)eventType.toUpperCase())).map(BulkheadEventDTOFactory::createBulkheadEventDTO).toJavaList();
        return new BulkheadEventsEndpointResponse(response);
    }

    private List<BulkheadEvent> getBulkheadEvent(String bulkheadName) {
        CircularEventConsumer eventConsumer = this.eventConsumerRegistry.getEventConsumer(bulkheadName);
        if (eventConsumer != null) {
            return eventConsumer.getBufferedEvents().filter(event -> event.getBulkheadName().equals(bulkheadName));
        }
        return List.empty();
    }
}

