/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.autoconfigure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.prometheus.collectors.CircuitBreakerMetricsCollector;
import io.github.resilience4j.prometheus.publisher.CircuitBreakerMetricsPublisher;
import io.prometheus.client.GaugeMetricFamily;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={GaugeMetricFamily.class, CircuitBreaker.class, CircuitBreakerMetricsPublisher.class})
@ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.enabled"}, matchIfMissing=true)
public class CircuitBreakerPrometheusAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.legacy.enabled"}, havingValue="true")
    @ConditionalOnMissingBean
    public CircuitBreakerMetricsCollector circuitBreakerPrometheusCollector(CircuitBreakerRegistry circuitBreakerRegistry) {
        CircuitBreakerMetricsCollector collector = CircuitBreakerMetricsCollector.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry);
        collector.register();
        return collector;
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.circuitbreaker.metrics.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean
    public CircuitBreakerMetricsPublisher circuitBreakerPrometheusPublisher() {
        return new CircuitBreakerMetricsPublisher();
    }
}

