/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common;

import io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
@ConfigurationPropertiesBinding
@Order(value=0)
public class IntegerToDurationConverter
implements Converter<Integer, Duration> {
    public Duration convert(@Nullable Integer source) {
        if (source != null) {
            try {
                return Duration.ofMillis(source.intValue());
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Cannot convert '" + source + "' to Duration", e);
            }
        }
        return null;
    }
}

