/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.monitoring.endpoint;

import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEndpointResponse;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import java.util.List;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.retries")
public class RetryEndpoint
extends AbstractEndpoint {
    private final RetryRegistry retryRegistry;

    public RetryEndpoint(RetryRegistry retryRegistry) {
        super("retries");
        this.retryRegistry = retryRegistry;
    }

    public RetryEndpointResponse invoke() {
        List retries = this.retryRegistry.getAllRetries().map(Retry::getName).sorted().toJavaList();
        return new RetryEndpointResponse(retries);
    }
}

