/*
 * Decompiled with CFR 0.152.
 */
package io.github.rybalkinsd.kohttp.interceptors;

import java.net.SocketTimeoutException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/rybalkinsd/kohttp/interceptors/RetryInterceptor;", "Lokhttp3/Interceptor;", "failureThreshold", "", "invocationTimeout", "", "ratio", "errorStatuses", "", "(IJILjava/util/List;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isRetry", "", "response", "attemptsCount", "isRetry$kohttp", "performAndReturnDelay", "delay", "performAndReturnDelay$kohttp", "shouldDelay", "kohttp"})
public final class RetryInterceptor
implements Interceptor {
    private final int failureThreshold;
    private final long invocationTimeout;
    private final int ratio;
    private final List<Integer> errorStatuses;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        int attemptsCount = 0;
        long delay = this.invocationTimeout;
        while (true) {
            block5: {
                try {
                    Response response;
                    if (this.shouldDelay(attemptsCount)) {
                        delay = this.performAndReturnDelay$kohttp(delay);
                    }
                    Response response2 = response = chain.proceed(request);
                    Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
                    if (!this.isRetry$kohttp(response2, attemptsCount)) {
                        return response;
                    }
                }
                catch (SocketTimeoutException e) {
                    if (attemptsCount < this.failureThreshold) break block5;
                    throw (Throwable)e;
                }
            }
            ++attemptsCount;
        }
    }

    public final long performAndReturnDelay$kohttp(long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return delay * (long)this.ratio;
    }

    private final boolean shouldDelay(int attemptsCount) {
        return this.invocationTimeout > 0L && attemptsCount > 0;
    }

    public final boolean isRetry$kohttp(@NotNull Response response, int attemptsCount) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        return attemptsCount < this.failureThreshold && this.errorStatuses.contains(response.code());
    }

    public RetryInterceptor(int failureThreshold, long invocationTimeout, int ratio, @NotNull List<Integer> errorStatuses) {
        Intrinsics.checkParameterIsNotNull(errorStatuses, (String)"errorStatuses");
        this.failureThreshold = failureThreshold;
        this.invocationTimeout = invocationTimeout;
        this.ratio = ratio;
        this.errorStatuses = errorStatuses;
    }

    public /* synthetic */ RetryInterceptor(int n, long l, int n2, List list, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 3;
        }
        if ((n3 & 2) != 0) {
            l = 0L;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        if ((n3 & 8) != 0) {
            list = CollectionsKt.listOf((Object[])new Integer[]{503, 504});
        }
        this(n, l, n2, list);
    }

    public RetryInterceptor() {
        this(0, 0L, 0, null, 15, null);
    }
}

