/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.code_provider;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;

public class CleanthatPathHelpers {
    protected CleanthatPathHelpers() {
    }

    public static void checkContentPath(Path path) {
        if (path.isAbsolute()) {
            throw new IllegalArgumentException("Should be relative: " + path);
        }
        if (path.getRoot() != null) {
            throw new IllegalArgumentException("Should not have a root: " + path);
        }
    }

    public static Path resolveChild(Path parent, String child) throws InvalidPathException, IllegalArgumentException {
        return CleanthatPathHelpers.resolveChild(parent, parent.getFileSystem().getPath(child, new String[0]));
    }

    public static Path resolveChild(Path parent, Path child) throws IllegalArgumentException {
        int minDiff;
        if (child.getRoot() != null) {
            throw new IllegalArgumentException("Child path has root");
        }
        if (child.isAbsolute()) {
            throw new IllegalArgumentException("Child path is absolute");
        }
        Path dummy = parent.getFileSystem().getPath("dummy", new String[0]);
        Path otherDummyNormalized = dummy.resolve(child).normalize();
        if (otherDummyNormalized.getNameCount() != 1 + child.getNameCount()) {
            throw new IllegalArgumentException("Invalid child path");
        }
        if (!otherDummyNormalized.startsWith(dummy) || !otherDummyNormalized.endsWith(child)) {
            throw new IllegalArgumentException("Invalid child path");
        }
        Path result = parent.resolve(child);
        Path resultNormalized = result.normalize();
        Path thisNormalized = parent.normalize();
        if (CleanthatPathHelpers.isEmptyPath(thisNormalized)) {
            minDiff = 0;
            if (CleanthatPathHelpers.isEmptyPath(resultNormalized)) {
                throw new IllegalArgumentException("Invalid child path");
            }
        } else {
            minDiff = 1;
            if (!resultNormalized.startsWith(thisNormalized)) {
                throw new IllegalArgumentException("Invalid child path");
            }
        }
        if (resultNormalized.getNameCount() - thisNormalized.getNameCount() < minDiff) {
            throw new IllegalArgumentException("Invalid child path");
        }
        return result;
    }

    private static boolean isEmptyPath(Path p) {
        return p.getRoot() == null && p.getNameCount() == 1 && p.getName(0).toString().isEmpty();
    }

    public static Path makeContentPath(Path repositoryRoot, String pathString) {
        Path absoluteContentPath = CleanthatPathHelpers.resolveChild(repositoryRoot, pathString);
        Path relativeContentPath = repositoryRoot.relativize(absoluteContentPath);
        CleanthatPathHelpers.checkContentPath(relativeContentPath);
        return relativeContentPath;
    }

    public static String makeContentRawPath(Path repositoryRoot, Path contentPath) {
        Path childrenAbsolutePath = CleanthatPathHelpers.resolveChild(repositoryRoot, contentPath);
        return repositoryRoot.relativize(childrenAbsolutePath).toString();
    }
}

