/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.resolution.Resolvable;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserAstMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.function.OnMethodName;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.IJavaparserNodeMutator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AJavaparserNodeMutator
extends AJavaparserAstMutator
implements IJavaparserNodeMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AJavaparserNodeMutator.class);
    private final AtomicInteger nbReplaceIssues = new AtomicInteger();
    private final AtomicInteger nbRemoveIssues = new AtomicInteger();

    public int getNbReplaceIssues() {
        return this.nbReplaceIssues.get();
    }

    public int getNbRemoveIssues() {
        return this.nbRemoveIssues.get();
    }

    protected Optional<Node> replaceNode(NodeAndSymbolSolver<?> nodeAndSymbolSolver) {
        throw new UnsupportedOperationException("TODO Implement me in overriden classes");
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> nodeAndSymbolSolver) {
        Optional<Node> optReplacement = this.replaceNode(nodeAndSymbolSolver);
        if (optReplacement.isPresent()) {
            Node replacement = optReplacement.get();
            return this.tryReplace((Node)nodeAndSymbolSolver.getNode(), replacement);
        }
        return false;
    }

    protected boolean tryReplace(NodeAndSymbolSolver<?> node, Node replacement) {
        return this.tryReplace((Node)node.getNode(), replacement);
    }

    protected boolean tryReplace(Node node, Node replacement) {
        if (this.cancelDueToComment(node)) {
            LOGGER.info("We skip replacing {} due to the presence of a comment", (Object)node);
            return false;
        }
        LOGGER.info("{} is turning `{}` into `{}`", new Object[]{this.getClass().getSimpleName(), node, replacement});
        boolean result = node.replace(replacement);
        if (!result) {
            this.nbReplaceIssues.incrementAndGet();
            LOGGER.warn("{} failed turning `{}` into `{}`", new Object[]{this.getClass().getSimpleName(), node, replacement});
        }
        return result;
    }

    protected boolean tryRemove(Node node) {
        if (this.cancelDueToComment(node)) {
            LOGGER.info("We skip removing {} due to the presence of a comment", (Object)node);
            return false;
        }
        String nodeParentAsString = node.getParentNode().map(n -> n.getClass().getSimpleName()).orElse("-");
        LOGGER.info("Removing `{}` from a {}", (Object)node, (Object)nodeParentAsString);
        boolean result = node.remove();
        if (!result) {
            this.nbRemoveIssues.incrementAndGet();
            LOGGER.warn("Failed removing `{}` from a {}", (Object)node, (Object)nodeParentAsString);
        }
        return result;
    }

    protected boolean cancelDueToComment(Node node) {
        if (node.findFirst(Node.class, n -> n.getComment().isPresent()).isPresent()) {
            LOGGER.debug("You should cancel the operation due to the presence of a comment");
            return true;
        }
        return false;
    }

    public static void logJavaParserIssue(Object o, Throwable e, String issue) {
        String msg = "We encounter a case of {} for `{}`. Full-stack is available in 'debug'";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(msg, new Object[]{issue, o, e});
        } else {
            LOGGER.warn(msg, (Object)issue, o);
        }
    }

    protected Optional<ResolvedDeclaration> optResolved(Expression expr) {
        if (expr.findCompilationUnit().isEmpty()) {
            return Optional.empty();
        }
        if (!(expr instanceof Resolvable)) {
            return Optional.empty();
        }
        try {
            Object resolved = ((Resolvable)expr).resolve();
            return Optional.of((ResolvedDeclaration)resolved);
        }
        catch (UnsolvedSymbolException e) {
            LOGGER.debug("Typically a 3rd-party symbol (e.g. in some library not loaded by CleanThat)", (Throwable)e);
            return Optional.empty();
        }
        catch (IllegalStateException | UnsupportedOperationException e) {
            if (e.getMessage().contains(SymbolResolver.class.getSimpleName())) {
                LOGGER.debug("Typically a 3rd-party symbol (e.g. in some library not loaded by CleanThat)", (Throwable)e);
                return Optional.empty();
            }
            if (e.getMessage().contains("unsolved symbol")) {
                LOGGER.debug("Typically a 3rd-party symbol (e.g. in some library not loaded by CleanThat)", (Throwable)e);
                return Optional.empty();
            }
            throw new IllegalStateException(e);
        }
    }

    protected void onMethodName(NodeAndSymbolSolver<?> nodeAndSolver, String methodName, OnMethodName consumer) {
        Object node = nodeAndSolver.getNode();
        if (node instanceof MethodCallExpr && methodName.equals(((MethodCallExpr)node).getName().getIdentifier())) {
            MethodCallExpr methodCall = (MethodCallExpr)node;
            Optional optScope = methodCall.getScope();
            if (optScope.isEmpty()) {
                return;
            }
            Expression scope = (Expression)optScope.get();
            Optional<ResolvedType> type = MethodCallExprHelpers.optResolvedType(nodeAndSolver.editNode(scope));
            if (type.isPresent()) {
                consumer.onMethodName(methodCall, scope, type.get());
            }
        }
    }

    protected boolean isMethodReturnUsed(MethodCallExpr methodCall) {
        if (!methodCall.getParentNode().isPresent()) {
            return false;
        }
        Node parentNode = (Node)methodCall.getParentNode().get();
        return !(parentNode instanceof ExpressionStmt);
    }
}

