/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class ComparisonWithNaN
extends AJavaparserNodeMutator {
    public String minimalJavaVersion() {
        return "11";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    public boolean isDraft() {
        return false;
    }

    public Optional<String> getPmdId() {
        return Optional.of("ComparisonWithNaN");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_errorprone.html#comparisonwithnan";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        MethodCallExpr replacement;
        Class methodHolderClass;
        boolean prefixNullCheck;
        Expression mayNotBeNaN;
        if (!(node.getNode() instanceof BinaryExpr)) {
            return false;
        }
        BinaryExpr binaryExpr = (BinaryExpr)node.getNode();
        if (this.isEquals(binaryExpr)) {
            return false;
        }
        Expression left = binaryExpr.getLeft();
        Expression right = binaryExpr.getRight();
        if (this.isNaNReference(node.editNode(right))) {
            mayNotBeNaN = left;
        } else if (this.isNaNReference(node.editNode(left))) {
            mayNotBeNaN = right;
        } else {
            return false;
        }
        if (MethodCallExprHelpers.scopeHasRequiredType(node.editNode(mayNotBeNaN), Float.TYPE)) {
            prefixNullCheck = false;
            methodHolderClass = Float.class;
        } else if (MethodCallExprHelpers.scopeHasRequiredType(node.editNode(mayNotBeNaN), Double.TYPE)) {
            prefixNullCheck = false;
            methodHolderClass = Double.class;
        } else if (MethodCallExprHelpers.scopeHasRequiredType(node.editNode(mayNotBeNaN), Float.class)) {
            prefixNullCheck = true;
            methodHolderClass = Float.class;
        } else if (MethodCallExprHelpers.scopeHasRequiredType(node.editNode(mayNotBeNaN), Double.class)) {
            prefixNullCheck = true;
            methodHolderClass = Double.class;
        } else {
            return false;
        }
        NameExpr nameExpr = new NameExpr(methodHolderClass.getSimpleName());
        MethodCallExpr properNaNCall = new MethodCallExpr((Expression)nameExpr, "isNaN", new NodeList((Node[])new Expression[]{mayNotBeNaN}));
        if (prefixNullCheck) {
            BinaryExpr notNull = new BinaryExpr(mayNotBeNaN, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS);
            replacement = new BinaryExpr((Expression)notNull, (Expression)properNaNCall, BinaryExpr.Operator.AND);
        } else {
            replacement = properNaNCall;
        }
        return this.tryReplace(node, (Node)replacement);
    }

    private boolean isEquals(BinaryExpr binaryExpr) {
        return binaryExpr.getOperator() != BinaryExpr.Operator.EQUALS;
    }

    private boolean isNaNReference(NodeAndSymbolSolver<? extends Expression> left) {
        if (!left.getNode().isFieldAccessExpr()) {
            return false;
        }
        FieldAccessExpr fieldAccessExpr = left.getNode().asFieldAccessExpr();
        if (!"NaN".equals(fieldAccessExpr.getNameAsString())) {
            return false;
        }
        return MethodCallExprHelpers.scopeHasRequiredType(left.editNode(fieldAccessExpr.getScope()), Double.class) || MethodCallExprHelpers.scopeHasRequiredType(left.editNode(fieldAccessExpr.getScope()), Float.class);
    }
}

