/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedLambdaConstraintType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class LambdaIsMethodReference
extends AJavaparserNodeMutator {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream");
    }

    public boolean isDraft() {
        return true;
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1612");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("LambdaToMethodReference");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/lambda-to-method-reference.html#code-changes";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> nodeAndSymbolSolver) {
        Object node = nodeAndSymbolSolver.getNode();
        if (!(node instanceof LambdaExpr)) {
            return false;
        }
        LambdaExpr lambdaExpr = (LambdaExpr)node;
        if (lambdaExpr.getParameters().size() == 1) {
            Parameter singleParameter = (Parameter)lambdaExpr.getParameters().get(0);
            return this.hasOneVariable(nodeAndSymbolSolver, lambdaExpr, singleParameter);
        }
        return false;
    }

    private boolean hasOneVariable(NodeAndSymbolSolver<?> context, LambdaExpr lambdaExpr, Parameter singleParameter) {
        Statement body = lambdaExpr.getBody();
        if (!body.isExpressionStmt()) {
            return false;
        }
        ExpressionStmt asExpressionStmt = body.asExpressionStmt();
        Expression expression = asExpressionStmt.getExpression();
        if (expression.isInstanceOfExpr()) {
            return this.onInstanceOf(lambdaExpr, singleParameter, expression);
        }
        if (expression.isCastExpr()) {
            return this.onCast(lambdaExpr, singleParameter, expression);
        }
        if (expression.isBinaryExpr()) {
            BinaryExpr binaryExpr = expression.asBinaryExpr();
            BinaryExpr.Operator operator = binaryExpr.getOperator();
            Expression left = binaryExpr.getLeft();
            Expression right = binaryExpr.getRight();
            if ((operator == BinaryExpr.Operator.EQUALS || operator == BinaryExpr.Operator.NOT_EQUALS) && (left.isNullLiteralExpr() || right.isNullLiteralExpr())) {
                String methodIdentifier;
                Expression notNunull;
                if (left.isNullLiteralExpr()) {
                    if (right.isNullLiteralExpr()) {
                        return this.tryReplace((Node)binaryExpr, (Node)new BooleanLiteralExpr(true));
                    }
                    notNunull = right;
                } else {
                    notNunull = left;
                }
                if (!notNunull.isNameExpr() || !notNunull.asNameExpr().getName().equals((Object)singleParameter.getName())) {
                    return false;
                }
                if (operator == BinaryExpr.Operator.EQUALS) {
                    methodIdentifier = "isNull";
                } else {
                    assert (operator == BinaryExpr.Operator.NOT_EQUALS);
                    methodIdentifier = "nonNull";
                }
                MethodReferenceExpr methodReference = new MethodReferenceExpr((Expression)new TypeExpr((Type)new ClassOrInterfaceType(null, Objects.class.getSimpleName())), new NodeList(), methodIdentifier);
                return lambdaExpr.replace((Node)methodReference);
            }
        } else if (expression.isMethodCallExpr()) {
            MethodCallExpr methodCallExpr = expression.asMethodCallExpr();
            return this.onMethodCall(context, lambdaExpr, singleParameter, methodCallExpr);
        }
        return false;
    }

    private boolean onCast(LambdaExpr lambdaExpr, Parameter singleParameter, Expression expression) {
        CastExpr castExpr = expression.asCastExpr();
        if (!castExpr.getType().isClassOrInterfaceType()) {
            return false;
        }
        ClassOrInterfaceType asClassOrInterfaceType = castExpr.getType().asClassOrInterfaceType();
        if (asClassOrInterfaceType.getTypeArguments().isPresent()) {
            return false;
        }
        Optional<ResolvedType> optResolvedType = ResolvedTypeHelpers.optResolvedType((Type)asClassOrInterfaceType);
        if (optResolvedType.isEmpty()) {
            return false;
        }
        if (optResolvedType.get().isTypeVariable()) {
            return false;
        }
        if (!castExpr.getExpression().isNameExpr() || !castExpr.getExpression().asNameExpr().getName().equals((Object)singleParameter.getName())) {
            return false;
        }
        ClassExpr newScope = new ClassExpr(castExpr.getType());
        MethodReferenceExpr methodReference = new MethodReferenceExpr((Expression)newScope, new NodeList(), "cast");
        return this.tryReplace((Node)lambdaExpr, (Node)methodReference);
    }

    private boolean onInstanceOf(LambdaExpr lambdaExpr, Parameter singleParameter, Expression expression) {
        InstanceOfExpr instanceOfExpr = expression.asInstanceOfExpr();
        if (!instanceOfExpr.getExpression().isNameExpr() || !instanceOfExpr.getExpression().asNameExpr().getName().equals((Object)singleParameter.getName())) {
            return false;
        }
        ClassExpr newScope = new ClassExpr((Type)instanceOfExpr.getType());
        MethodReferenceExpr methodReference = new MethodReferenceExpr((Expression)newScope, new NodeList(), "isInstance");
        return this.tryReplace((Node)lambdaExpr, (Node)methodReference);
    }

    private boolean onMethodCall(NodeAndSymbolSolver<?> context, LambdaExpr lambdaExpr, Parameter singleParameter, MethodCallExpr methodCallExpr) {
        Optional optScope = methodCallExpr.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        if (methodCallExpr.getArguments().size() == 1 && ((Expression)methodCallExpr.getArguments().get(0)).isNameExpr() && ((Expression)methodCallExpr.getArguments().get(0)).asNameExpr().getName().equals((Object)singleParameter.getName())) {
            Optional<ResolvedType> scopeType = MethodCallExprHelpers.optResolvedType(context.editNode(scope));
            if (scopeType.isEmpty()) {
                return false;
            }
            if (!scopeType.get().isReferenceType()) {
                return false;
            }
            MethodReferenceExpr methodReference = new MethodReferenceExpr(scope, new NodeList(), methodCallExpr.getNameAsString());
            return this.tryReplace((Node)lambdaExpr, (Node)methodReference);
        }
        if (methodCallExpr.getArguments().isEmpty() && ((Expression)optScope.get()).isNameExpr() && ((Expression)optScope.get()).asNameExpr().getName().equals((Object)singleParameter.getName())) {
            String qualifiedName;
            Optional<ResolvedType> scopeType = MethodCallExprHelpers.optResolvedType(context.editNode(scope));
            if (scopeType.isEmpty()) {
                return false;
            }
            if (!scopeType.get().isConstraint()) {
                return false;
            }
            ResolvedLambdaConstraintType constraint = scopeType.get().asConstraintType();
            ResolvedType resolvedBound = constraint.getBound();
            if (!resolvedBound.isReferenceType()) {
                return false;
            }
            ResolvedReferenceType refType = resolvedBound.asReferenceType();
            Optional optTypeDeclaration = refType.getTypeDeclaration();
            if (optTypeDeclaration.isEmpty()) {
                return false;
            }
            ResolvedReferenceTypeDeclaration typeDeclaration = (ResolvedReferenceTypeDeclaration)optTypeDeclaration.get();
            String packageName = typeDeclaration.getPackageName();
            String methodRefClassName = ImportDeclarationHelpers.isImported(context, packageName, qualifiedName = refType.getQualifiedName()) ? typeDeclaration.getName() : qualifiedName;
            MethodReferenceExpr methodReference = new MethodReferenceExpr((Expression)new NameExpr(methodRefClassName), methodCallExpr.getTypeArguments().orElseGet(() -> new NodeList()), methodCallExpr.getNameAsString());
            return this.tryReplace((Node)lambdaExpr, (Node)methodReference);
        }
        return false;
    }
}

