/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ObjectsHashCodePrimitive
extends AJavaparserExprMutator {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASSES = ImmutableMap.builder().put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).build();

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    public Optional<String> getErrorProneId() {
        return Optional.of("ObjectsHashCodePrimitive");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.getNode().asMethodCallExpr();
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!"hashCode".equals(methodCallIdentifier)) {
            return false;
        }
        if (methodCall.getArguments().size() != 1) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty() || !((Expression)optScope.get()).isNameExpr() || !"Objects".equals(((Expression)optScope.get()).asNameExpr().getNameAsString())) {
            return false;
        }
        Expression left = methodCall.getArgument(0);
        Optional<Map.Entry> optClass = PRIMITIVE_CLASSES.entrySet().stream().filter(c -> MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(left), (Class)c.getKey())).findAny();
        if (optClass.isPresent()) {
            MethodCallExpr replacement = new MethodCallExpr((Expression)new NameExpr(((Class)optClass.get().getValue()).getSimpleName()), "hashCode", new NodeList((Node[])new Expression[]{left}));
            return this.tryReplace(expr, (Node)replacement);
        }
        return false;
    }
}

