/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.meta.IReApplyUntilNoop;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaReturnsSingleStatement;
import java.util.Optional;
import java.util.Set;

@ApplyAfterMe(value={LambdaReturnsSingleStatement.class})
public class OptionalWrappedIfToFilter
extends AJavaparserExprMutator
implements IReApplyUntilNoop {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Optional");
    }

    protected Set<String> getEligibleForUnwrappedFilter() {
        return Set.of("ifPresent", "ifPresentOrElse");
    }

    protected Class<?> getExpectedScope() {
        return Optional.class;
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCallExpr = expr.getNode().asMethodCallExpr();
        if (!this.getEligibleForUnwrappedFilter().contains(methodCallExpr.getNameAsString())) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCallExpr.getScope()), this.getExpectedScope())) {
            return false;
        }
        if (methodCallExpr.getArguments().size() < 1) {
            return false;
        }
        Expression mayLambdaExpr = (Expression)methodCallExpr.getArguments().get(0);
        if (!mayLambdaExpr.isLambdaExpr()) {
            return false;
        }
        LambdaExpr ifPresentLambdaExpr = mayLambdaExpr.asLambdaExpr();
        if (!ifPresentLambdaExpr.getBody().isBlockStmt()) {
            return false;
        }
        if (ifPresentLambdaExpr.getParameters().size() != 1) {
            return false;
        }
        BlockStmt lambdaBlock = ifPresentLambdaExpr.getBody().asBlockStmt();
        if (lambdaBlock.getStatements().size() != 1) {
            return false;
        }
        Statement firstStatement = lambdaBlock.getStatement(0);
        if (!firstStatement.isIfStmt()) {
            return false;
        }
        IfStmt ifStmt = firstStatement.asIfStmt();
        if (ifStmt.hasElseBranch()) {
            return false;
        }
        Statement thenStmt = ifStmt.getThenStmt();
        Optional<LambdaExpr> optNewLambdaExpr = LambdaExprHelpers.makeLambdaExpr(ifPresentLambdaExpr.getParameter(0).getName(), thenStmt);
        if (optNewLambdaExpr.isEmpty()) {
            return false;
        }
        Expression condition = ifStmt.getCondition();
        if (condition.findFirst(NameExpr.class, n -> n.getNameAsString().equals(ifPresentLambdaExpr.getParameter(0).getNameAsString())).isEmpty()) {
            return false;
        }
        Optional<LambdaExpr> optFilterLambdaExpr = LambdaExprHelpers.makeLambdaExpr(ifPresentLambdaExpr.getParameter(0).getName(), (Statement)new ExpressionStmt(condition));
        if (optFilterLambdaExpr.isEmpty()) {
            return false;
        }
        this.tryReplace((Node)ifPresentLambdaExpr, (Node)optNewLambdaExpr.get());
        this.tryReplace((Node)ifStmt, (Node)thenStmt);
        Expression filterScope = (Expression)methodCallExpr.getScope().get();
        MethodCallExpr callFilter = new MethodCallExpr(filterScope, "filter", new NodeList((Node[])new Expression[]{(Expression)optFilterLambdaExpr.get()}));
        methodCallExpr.setScope((Expression)callFilter);
        filterScope.setParentNode((Node)callFilter);
        return true;
    }
}

