/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.PrimitiveType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.VariableDeclarationExprHepers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyBeforeMe;
import eu.solven.cleanthat.engine.java.refactorer.meta.RepeatOnSuccess;
import eu.solven.cleanthat.engine.java.refactorer.mutators.ARefactorConsecutiveStatements;
import eu.solven.cleanthat.engine.java.refactorer.mutators.RedundantLogicalComplementsInStream;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RepeatOnSuccess
@ApplyBeforeMe(value={RedundantLogicalComplementsInStream.class})
public class SimplifyBooleanInitialization
extends ARefactorConsecutiveStatements {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplifyBooleanInitialization.class);

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Redundancy", (Object)"Initialization");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-any-match.html";
    }

    public boolean isDraft() {
        return false;
    }

    @Override
    protected boolean trySimplifyingStatements(NodeAndSymbolSolver<BlockStmt> blockStmtAndSolver, Statement currentStmt, Statement nextStmt) {
        Optional<VariableDeclarationExpr> optAssignExpr = VariableDeclarationExprHepers.optSimpleDeclaration(currentStmt);
        if (optAssignExpr.isEmpty()) {
            return false;
        }
        VariableDeclarationExpr assignExpr = optAssignExpr.get();
        if (!assignExpr.getElementType().isPrimitiveType() || !PrimitiveType.Primitive.BOOLEAN.equals((Object)assignExpr.getElementType().asPrimitiveType().getType())) {
            return false;
        }
        VariableDeclarator singleVariable = assignExpr.getVariable(0);
        Optional optInitializer = singleVariable.getInitializer();
        if (optInitializer.isEmpty()) {
            return false;
        }
        if (!((Expression)optInitializer.get()).isBooleanLiteralExpr()) {
            return false;
        }
        if (!nextStmt.isIfStmt() || nextStmt.asIfStmt().getElseStmt().isPresent()) {
            return false;
        }
        IfStmt ifStmt = nextStmt.asIfStmt();
        Optional<AssignExpr> optIfAssignExpr = SimplifyBooleanInitialization.searchSingleAssignExpr(ifStmt.getThenStmt());
        if (optIfAssignExpr.isEmpty()) {
            return false;
        }
        AssignExpr ifAssignExpr = optIfAssignExpr.get();
        if (SimplifyBooleanInitialization.notAssignOperator(ifAssignExpr) || !ifAssignExpr.getTarget().isNameExpr() || !ifAssignExpr.getTarget().asNameExpr().getNameAsString().equals(singleVariable.getNameAsString())) {
            return false;
        }
        if (!ifAssignExpr.getValue().isBooleanLiteralExpr()) {
            return false;
        }
        boolean defaultValue = ((Expression)optInitializer.get()).asBooleanLiteralExpr().getValue();
        boolean ifTrueValue = ifAssignExpr.getValue().asBooleanLiteralExpr().getValue();
        if (!defaultValue && ifTrueValue) {
            if (this.tryRemove((Node)ifStmt)) {
                singleVariable.setInitializer(ifStmt.getCondition());
                return true;
            }
            LOGGER.debug("Issue removing `{}`", (Object)ifStmt);
        } else if (defaultValue && !ifTrueValue) {
            if (this.tryRemove((Node)ifStmt)) {
                Expression positiveExpression = ifStmt.getCondition();
                if (this.negatedNeedEnclosing(positiveExpression)) {
                    positiveExpression = new EnclosedExpr(positiveExpression);
                }
                singleVariable.setInitializer((Expression)new UnaryExpr(positiveExpression, UnaryExpr.Operator.LOGICAL_COMPLEMENT));
                return true;
            }
            LOGGER.debug("Issue removing `{}`", (Object)ifStmt);
        }
        return false;
    }

    private boolean negatedNeedEnclosing(Expression positiveExpression) {
        if (positiveExpression.isMethodCallExpr()) {
            return false;
        }
        return !positiveExpression.isEnclosedExpr();
    }

    static boolean notAssignOperator(AssignExpr ifAssignExpr) {
        return ifAssignExpr.getOperator() != AssignExpr.Operator.ASSIGN;
    }

    static Optional<AssignExpr> searchSingleAssignExpr(Statement thenStmt) {
        if (thenStmt.isExpressionStmt() && thenStmt.asExpressionStmt().getExpression().isAssignExpr()) {
            return Optional.of(thenStmt.asExpressionStmt().getExpression().asAssignExpr());
        }
        if (thenStmt.isBlockStmt() && thenStmt.asBlockStmt().getStatements().size() == 1) {
            Statement singleStmt = thenStmt.asBlockStmt().getStatement(0);
            return SimplifyBooleanInitialization.searchSingleAssignExpr(singleStmt);
        }
        return Optional.empty();
    }
}

