/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class StringFromString
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"String");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2129");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveNewStringConstructor");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-new-string-constructor.html";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isObjectCreationExpr()) {
            return false;
        }
        ObjectCreationExpr methodCall = expr.getNode().asObjectCreationExpr();
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCall), String.class)) {
            return false;
        }
        if (methodCall.getArguments().size() != 1) {
            return false;
        }
        Optional<Expression> optStringExpr = this.findStringExpr(expr.editNode(methodCall.getArgument(0)));
        if (optStringExpr.isEmpty()) {
            return false;
        }
        return this.tryReplace((Node)expr.getNode(), (Node)optStringExpr.get());
    }

    private Optional<Expression> findStringExpr(NodeAndSymbolSolver<Expression> argumentAndSolver) {
        Expression argument = argumentAndSolver.getNode();
        while (argument.isEnclosedExpr()) {
            argument = argument.asEnclosedExpr().getInner();
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(argumentAndSolver.editNode(argument), String.class)) {
            return Optional.empty();
        }
        return Optional.of(argument);
    }
}

