/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators.composite;

import com.google.common.collect.ImmutableList;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.codehaus.plexus.languages.java.version.JavaVersion;

public class CompositeMutator<T extends IMutator>
implements IMutator {
    final List<T> mutators;

    public CompositeMutator() {
        this(Arrays.asList(new IMutator[0]));
    }

    protected CompositeMutator(List<T> mutators) {
        this.mutators = ImmutableList.copyOf(mutators);
    }

    @Override
    public Set<String> getTags() {
        TreeSet<String> tags = new TreeSet<String>();
        tags.add("Composite");
        if (this.mutators.isEmpty()) {
            return tags;
        }
        TreeSet<String> intersection = new TreeSet<String>(((IMutator)this.mutators.iterator().next()).getTags());
        this.mutators.forEach(mutator -> intersection.retainAll(mutator.getTags()));
        tags.addAll(intersection);
        return Collections.unmodifiableSet(tags);
    }

    @Override
    public String minimalJavaVersion() {
        return this.mutators.stream().map(IMutator::minimalJavaVersion).min(Comparator.comparing(jdk -> JavaVersion.parse((String)jdk))).orElse("1");
    }

    public List<T> getUnderlyings() {
        return this.mutators;
    }

    public Set<String> getUnderlyingIds() {
        return this.mutators.stream().flatMap(ct -> ct.getIds().stream()).sorted().collect(Collectors.toCollection(TreeSet::new));
    }

    public static <T extends IMutator> List<T> filterWithJdk(JavaVersion sourceJdkVersion, List<? extends T> mutators) {
        return mutators.stream().filter(m -> sourceJdkVersion.isAtLeast(m.minimalJavaVersion())).collect(Collectors.toList());
    }
}

