/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.google.common.collect.ImmutableList;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerProperties;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IWalkingMutator;
import eu.solven.cleanthat.engine.java.refactorer.mutators.composite.AllIncludingDraftCompositeMutators;
import eu.solven.cleanthat.engine.java.refactorer.mutators.composite.AllIncludingDraftSingleMutators;
import eu.solven.cleanthat.engine.java.refactorer.mutators.composite.CompositeMutator;
import eu.solven.cleanthat.formatter.ILintFixerWithId;
import eu.solven.cleanthat.language.IEngineProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAstRefactorer<AST, P, R, M extends IWalkingMutator<AST, R>>
implements ILintFixerWithId {
    private static final Logger LOGGER = LoggerFactory.getLogger(AAstRefactorer.class);
    private final List<M> mutators;

    public AAstRefactorer(List<M> mutators) {
        this.mutators = ImmutableList.copyOf(mutators);
        this.mutators.forEach(ct -> LOGGER.debug("Using transformer: {}", ct.getIds()));
    }

    public Set<String> getMutators() {
        return this.mutators.stream().flatMap(m -> m.getIds().stream()).sorted().collect(Collectors.toSet());
    }

    protected Iterable<M> getRawMutators() {
        return this.mutators;
    }

    protected abstract P makeAstParser();

    protected abstract AST parseSourceCode(P var1, String var2);

    protected String applyTransformers(String dirtyCode) {
        AtomicReference<String> refCleanCode = new AtomicReference<String>(dirtyCode);
        AtomicReference optCompilationUnit = new AtomicReference();
        P parser = this.makeAstParser();
        this.getRawMutators().forEach(ct -> {
            Optional walkNodeResult;
            LOGGER.debug("Applying {}", ct);
            if (optCompilationUnit.get() == null) {
                try {
                    String sourceCode = (String)refCleanCode.get();
                    AST compilationUnit = this.parseSourceCode(parser, sourceCode);
                    optCompilationUnit.set(compilationUnit);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Issue parsing the code", e);
                }
            }
            Object compilationUnit = optCompilationUnit.get();
            try {
                walkNodeResult = ct.walkAst(compilationUnit);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Issue with classTransformer: " + ct, e);
            }
            if (walkNodeResult.isPresent()) {
                LOGGER.debug("A rule based on JavaParser actually modified the code");
                refCleanCode.set(this.toString(walkNodeResult.get()));
                optCompilationUnit.set(null);
            }
        });
        return refCleanCode.get();
    }

    public static List<IMutator> filterRules(IEngineProperties engineProperties, JavaRefactorerProperties properties) {
        JavaVersion engineVersion = JavaVersion.parse((String)engineProperties.getEngineVersion());
        List<String> includedRules = properties.getIncluded();
        List<String> excludedRules = properties.getExcluded();
        boolean includeDraft = properties.isIncludeDraft();
        return AAstRefactorer.filterRules(engineVersion, includedRules, excludedRules, includeDraft);
    }

    public static List<IMutator> filterRules(JavaVersion sourceCodeVersion, List<String> includedRules, List<String> excludedRules, boolean includeDraft) {
        List allSingleMutators = new AllIncludingDraftSingleMutators(sourceCodeVersion).getUnderlyings();
        List allCompositeMutators = new AllIncludingDraftCompositeMutators(sourceCodeVersion).getUnderlyings();
        List<IMutator> mutatorsMayComposite = includedRules.stream().flatMap(includedRule -> {
            if ("*".equals(includedRule)) {
                return allSingleMutators.stream();
            }
            List matchingMutators = Stream.concat(allSingleMutators.stream(), allCompositeMutators.stream()).filter(someMutator -> someMutator.getIds().contains(includedRule) || someMutator.getClass().getName().equals(includedRule)).collect(Collectors.toList());
            if (!matchingMutators.isEmpty()) {
                return matchingMutators.stream();
            }
            Optional<IMutator> optFromClassName = AAstRefactorer.loadMutatorFromClass(sourceCodeVersion, includedRule);
            if (optFromClassName.isPresent()) {
                return optFromClassName.stream();
            }
            LOGGER.warn("includedMutator={} did not match any mutator. singleIds={} compositeIds={}", new Object[]{includedRule, allSingleMutators.stream().flatMap(m -> m.getIds().stream()).collect(Collectors.toCollection(TreeSet::new)), allCompositeMutators.stream().flatMap(m -> m.getIds().stream()).collect(Collectors.toCollection(TreeSet::new))});
            return Stream.empty();
        }).collect(Collectors.toList());
        List<IMutator> mutatorsNotComposite = AAstRefactorer.unrollCompositeMutators(mutatorsMayComposite);
        return mutatorsNotComposite.stream().filter(mutator -> {
            boolean isExcluded;
            boolean bl = isExcluded = excludedRules.contains(mutator.getClass().getName()) || excludedRules.stream().anyMatch(excludedRule -> mutator.getIds().contains(excludedRule));
            if (isExcluded) {
                LOGGER.debug("We exclude '{}'", mutator.getIds());
            } else {
                LOGGER.debug("We include '{}'", mutator.getIds());
            }
            return !isExcluded;
        }).filter(ct -> {
            if (includeDraft) {
                return true;
            }
            if (mutatorsMayComposite.contains(ct)) {
                LOGGER.debug("Draft are not included by default but {} was listed explicitely", ct.getIds());
                return true;
            }
            return !ct.isDraft();
        }).collect(Collectors.toList());
    }

    private static Optional<IMutator> loadMutatorFromClass(JavaVersion sourceCodeVersion, String includedRule) {
        try {
            IMutator mutator;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> mutatorClass = Class.forName(includedRule, false, classLoader);
            if (CompositeMutator.class.isAssignableFrom(mutatorClass)) {
                Constructor<?> ctor = mutatorClass.getConstructor(JavaVersion.class);
                mutator = (IMutator)ctor.newInstance(sourceCodeVersion);
            } else {
                Constructor<?> ctor = mutatorClass.getConstructor(new Class[0]);
                mutator = (IMutator)ctor.newInstance(new Object[0]);
            }
            return Optional.of(mutator);
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("includedMutator {} is not present classname", (Object)includedRule, (Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unexpected constructor for includedMutator=" + includedRule, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Invalid class for includedMutator=" + includedRule, e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException("Issue instanciating includedMutator=" + includedRule, e);
        }
        return Optional.empty();
    }

    private static List<IMutator> unrollCompositeMutators(List<IMutator> mutatorsMayComposite) {
        List<IMutator> mutatorsNotComposite = mutatorsMayComposite;
        while (mutatorsNotComposite.stream().filter(m -> m instanceof CompositeMutator).findAny().isPresent()) {
            mutatorsNotComposite = mutatorsNotComposite.stream().flatMap(m -> {
                if (m instanceof CompositeMutator) {
                    return ((CompositeMutator)m).getUnderlyings().stream();
                }
                return Stream.of(m);
            }).collect(Collectors.toList());
        }
        return mutatorsNotComposite;
    }

    protected abstract String toString(R var1);
}

