/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators.scanner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.reflect.ClassPath;
import eu.solven.cleanthat.config.GitService;
import eu.solven.cleanthat.engine.java.refactorer.meta.IConstructorNeedsJdkVersion;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutatorsScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutatorsScanner.class);
    private static final AtomicInteger ERROR_COUNTS = new AtomicInteger();

    @VisibleForTesting
    public static int getErrorCount() {
        return ERROR_COUNTS.get();
    }

    public List<Class<? extends IMutator>> getPackageMutatorClasses(String packageName) {
        Set<String> classNames;
        try {
            classNames = MutatorsScanner.getClasses(packageName);
        }
        catch (IOException | ClassNotFoundException e) {
            ERROR_COUNTS.incrementAndGet();
            LOGGER.error("Issue loading mutators from {}", (Object)packageName, (Object)e);
            return Collections.emptyList();
        }
        if (classNames.isEmpty()) {
            String cleanThatSha1 = GitService.safeGetSha1();
            LOGGER.warn("CleanThat failed detecting a single mutator in {} sha1={}", (Object)packageName, (Object)cleanThatSha1);
        }
        List<Class<? extends IMutator>> classes = classNames.stream().map(s -> {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                ERROR_COUNTS.incrementAndGet();
                LOGGER.error("Issue with {}", s, (Object)e);
                return null;
            }
        }).filter(c -> IMutator.class.isAssignableFrom((Class<?>)c)).filter(c -> !Modifier.isAbstract(c.getModifiers())).map(c -> c.asSubclass(IMutator.class)).collect(Collectors.toList());
        return classes;
    }

    public static List<IMutator> instantiate(JavaVersion sourceJdkVersion, List<Class<? extends IMutator>> classes) {
        return classes.stream().filter(c -> c != null).filter(c -> IMutator.class.isAssignableFrom((Class<?>)c)).map(c -> MutatorsScanner.instantiate(sourceJdkVersion, c)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T extends IMutator> T instantiate(JavaVersion sourceJdkVersion, Class<? extends T> mutatorClass) {
        try {
            if (IConstructorNeedsJdkVersion.class.isAssignableFrom(mutatorClass)) {
                return (T)((IMutator)mutatorClass.getConstructor(JavaVersion.class).newInstance(sourceJdkVersion));
            }
            return (T)((IMutator)mutatorClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            ERROR_COUNTS.incrementAndGet();
            LOGGER.error("Issue with {}", mutatorClass, (Object)e);
            return null;
        }
    }

    private static Set<String> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        TreeSet<String> classNames = new TreeSet<String>();
        try {
            ClassPath classpath = ClassPath.from((ClassLoader)loader);
            for (ClassPath.ClassInfo classInfo : classpath.getTopLevelClasses(packageName)) {
                classNames.add(classInfo.getName());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue with " + packageName, e);
        }
        return classNames;
    }

    public static Collection<Class<? extends IMutator>> scanPackageMutators(String packageName) {
        return new MutatorsScanner().getPackageMutatorClasses(packageName);
    }
}

