/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components;

import io.github.springwolf.asyncapi.v3.model.channel.message.Message;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.components.ComponentSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.schemas.SwaggerSchemaService;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentsService
implements ComponentsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentsService.class);
    private final SwaggerSchemaService schemaService;
    private final SpringwolfConfigProperties springwolfConfigProperties;
    private final Map<String, ComponentSchema> schemas = new HashMap<String, ComponentSchema>();
    private final Map<String, Message> messages = new HashMap<String, Message>();

    @Override
    public Map<String, ComponentSchema> getSchemas() {
        return this.schemas;
    }

    @Override
    public ComponentSchema resolvePayloadSchema(Type type, String contentType) {
        SwaggerSchemaService.ExtractedSchemas payload = this.schemaService.resolveSchema(type, contentType);
        payload.referencedSchemas().forEach(this.schemas::putIfAbsent);
        return payload.rootSchema();
    }

    @Override
    public String registerSchema(SchemaObject headers) {
        log.debug("Registering schema for {}", (Object)headers.getTitle());
        SchemaObject headerSchema = this.schemaService.extractSchema(headers);
        this.schemas.putIfAbsent(headers.getTitle(), ComponentSchema.of((SchemaObject)headerSchema));
        return headers.getTitle();
    }

    @Override
    public Map<String, Message> getMessages() {
        return this.messages;
    }

    @Override
    public MessageReference registerMessage(MessageObject message) {
        log.debug("Registering message for {}", (Object)message.getMessageId());
        this.messages.putIfAbsent(message.getMessageId(), (Message)message);
        return MessageReference.toComponentMessage((MessageObject)message);
    }

    @Override
    public String getSchemaName(Type type) {
        return this.schemaService.getNameFromType(type);
    }

    @Override
    public String getSimpleSchemaName(Type type) {
        return this.schemaService.getSimpleNameFromType(type);
    }

    @Generated
    public DefaultComponentsService(SwaggerSchemaService schemaService, SpringwolfConfigProperties springwolfConfigProperties) {
        this.schemaService = schemaService;
        this.springwolfConfigProperties = springwolfConfigProperties;
    }
}

